/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.generator;

import anyframe.core.query.impl.jdbc.generator.AbstractPagingSQLGenerator;

public class AltibasePagingSQLGenerator
extends AbstractPagingSQLGenerator {
    public String getPaginationSQL(String originalSql, Object[] originalArgs, int[] originalArgTypes, int pageIndex, int pageSize) throws Exception {
        if (pageIndex < 1 || pageSize < 1) {
            throw new Exception("Query Service : Can't generate paging SQL under Altibase. Because page number or page size is smaller than 1. [current page number = " + pageIndex + ", page size = " + pageSize + "]");
        }
        StringBuffer sql = new StringBuffer(originalSql);
        sql.append(" limit ?, ?");
        this.setQueryArgs(originalArgs, pageIndex, pageSize);
        this.setQueryArgTypes(originalArgTypes);
        return sql.toString();
    }

    protected void setQueryArgs(Object[] originalArgs, int pageIndex, int pageSize) {
        Object[] args = new Object[originalArgs.length + 2];
        for (int i = 0; i < originalArgs.length; ++i) {
            args[i] = originalArgs[i];
        }
        args[originalArgs.length] = new Long((pageIndex - 1) * pageSize + 1);
        System.out.println("####################### new Long(((pageIndex - 1) * pageSize) + 1) : " + new Long((pageIndex - 1) * pageSize + 1));
        System.out.println("####################### args[originalArgs.length] : " + args[originalArgs.length]);
        args[originalArgs.length + 1] = new Long(pageSize);
        this.setArgs(args);
    }

    protected void setQueryArgTypes(int[] originalArgTypes) {
        int[] argTypes = new int[originalArgTypes.length + 2];
        for (int i = 0; i < originalArgTypes.length; ++i) {
            argTypes[i] = originalArgTypes[i];
        }
        argTypes[originalArgTypes.length] = -5;
        argTypes[originalArgTypes.length + 1] = -5;
        this.setArgTypes(argTypes);
    }
}

