/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.generator;

import anyframe.core.query.impl.jdbc.generator.AbstractPagingSQLGenerator;

public class DB2PagingSQLGenerator
extends AbstractPagingSQLGenerator {
    public String getPaginationSQL(String originalSql, Object[] originalArgs, int[] originalArgTypes, int pageIndex, int pageSize) {
        this.setQueryArgs(originalArgs, pageIndex, pageSize);
        this.setQueryArgTypes(originalArgTypes);
        originalSql = originalSql.trim();
        StringBuffer sql = new StringBuffer("SELECT * FROM ( ");
        sql.append("SELECT rownumber() over() as ROW_SEQ, ");
        if (this.isDistinct(originalSql)) {
            sql.append("row_.* FROM (");
            sql.append(originalSql.substring(0));
            sql.append(") AS row_ ");
            sql.append(") AS INNER_TABLE WHERE ROW_SEQ BETWEEN ? AND ?");
            return sql.toString();
        }
        if (this.isOrderBy(originalSql) || this.isAll(originalSql)) {
            sql.append("INNER_TABLE.* FROM (");
            sql.append(originalSql.substring(0));
            sql.append(") AS INNER_TABLE ) WHERE ROW_SEQ BETWEEN ? AND ?");
            return sql.toString();
        }
        sql.append(originalSql.substring(6));
        sql.append(") AS INNER_TABLE WHERE ROW_SEQ BETWEEN ? AND ?");
        return sql.toString();
    }

    protected void setQueryArgs(Object[] originalArgs, int pageIndex, int pageSize) {
        Object[] args = new Object[originalArgs.length + 2];
        for (int i = 0; i < originalArgs.length; ++i) {
            args[i] = originalArgs[i];
        }
        args[originalArgs.length] = new Long((pageIndex - 1) * pageSize + 1);
        args[originalArgs.length + 1] = new Long(pageIndex * pageSize);
        this.setArgs(args);
    }

    protected void setQueryArgTypes(int[] originalArgTypes) {
        int[] argTypes = new int[originalArgTypes.length + 2];
        for (int i = 0; i < originalArgTypes.length; ++i) {
            argTypes[i] = originalArgTypes[i];
        }
        argTypes[originalArgTypes.length] = -5;
        argTypes[originalArgTypes.length + 1] = -5;
        this.setArgTypes(argTypes);
    }

    public boolean isDistinct(String sql) {
        String others = sql.substring(6);
        return others.toUpperCase().trim().startsWith("DISTINCT");
    }

    public boolean isAll(String sql) {
        String others = sql.substring(6);
        return others.trim().startsWith("*");
    }

    public boolean isOrderBy(String sql) {
        int orderbyIdx = (sql = sql.toUpperCase().replaceAll(" ", "")).indexOf("ORDERBY");
        return orderbyIdx != -1;
    }
}

