/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.lob;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.sql.CLOB;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.FileCopyUtils;

public class AnyframeOracle8iLobHandler
extends OracleLobHandler {
    private static final String CONNECTION_CLASS_NAME = "oracle.jdbc.OracleConnection";
    private static final String BLOB_CLASS_NAME = "oracle.sql.BLOB";
    private static final String CLOB_CLASS_NAME = "oracle.sql.CLOB";
    private final Class connectionClass;
    private final Class blobClass;
    private final Class clobClass;
    private final Method getCLOBMethod;
    private final Method getBLOBMethod;
    private final Method getCLOBStream;
    private final Method getBLOBStream;
    private final Map durationSessionConstants = new HashMap(2);
    private final Map modeReadWriteConstants = new HashMap(2);
    private NativeJdbcExtractor nativeJdbcExtractor;
    private Boolean cache = Boolean.TRUE;
    static /* synthetic */ Class class$java$sql$Connection;

    public AnyframeOracle8iLobHandler() {
        this("oracle.jdbc.OracleResultSet");
    }

    public AnyframeOracle8iLobHandler(String resultSetSpyName) {
        try {
            Class<?> rsClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(resultSetSpyName);
            this.connectionClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(CONNECTION_CLASS_NAME);
            this.blobClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(BLOB_CLASS_NAME);
            this.clobClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(CLOB_CLASS_NAME);
            if (resultSetSpyName.endsWith("OracleResultSet")) {
                this.getCLOBMethod = rsClass.getMethod("getCLOB", Integer.TYPE);
                this.getBLOBMethod = rsClass.getMethod("getBLOB", Integer.TYPE);
            } else {
                this.getCLOBMethod = rsClass.getMethod("getClob", Integer.TYPE);
                this.getBLOBMethod = rsClass.getMethod("getBlob", Integer.TYPE);
            }
            this.getCLOBStream = this.clobClass.getMethod("getCharacterOutputStream", new Class[0]);
            this.getBLOBStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Query Service : Couldn't initialize OracleLobHandler because Oracle driver classes are not available", ex);
        }
    }

    public void setBlobOutputValue(ResultSet rs, int columnIndex, byte[] blobValue) throws SQLException {
        ResultSet oRs = this.nativeJdbcExtractor.getNativeResultSet(rs);
        try {
            Object blob = this.getBLOBMethod.invoke((Object)oRs, new Integer(columnIndex));
            BufferedOutputStream writer = new BufferedOutputStream((OutputStream)this.getBLOBStream.invoke(blob, new Object[0]));
            writer.write(blobValue);
            writer.close();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setClobOutputValue(ResultSet rs, int columnIndex, String clobValue) throws SQLException {
        ResultSet oRs = this.nativeJdbcExtractor.getNativeResultSet(rs);
        try {
            CLOB clob = (CLOB)this.getCLOBMethod.invoke((Object)oRs, new Integer(columnIndex));
            long pos = 0L;
            pos = clob.length() + 1L;
            clob.putString(pos, clobValue);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public void setCache(boolean cache) {
        this.cache = new Boolean(cache);
    }

    public byte[] getBlobAsBytes(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        if (blob != null) {
            return blob.getBytes(1L, (int)blob.length());
        }
        return null;
    }

    public byte[] getBlobAsBytes(ResultSet rs, String columnName) throws SQLException {
        Blob blob = rs.getBlob(columnName);
        if (blob != null) {
            return blob.getBytes(1L, (int)blob.length());
        }
        return null;
    }

    public InputStream getBlobAsBinaryStream(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        if (blob != null) {
            return blob.getBinaryStream();
        }
        return null;
    }

    public String getClobAsString(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob != null) {
            return clob.getSubString(1L, (int)clob.length() - 1);
        }
        return null;
    }

    public String getClobAsString(ResultSet rs, String columnName) throws SQLException {
        Clob clob = rs.getClob(columnName);
        if (clob != null) {
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    public InputStream getClobAsAsciiStream(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob != null) {
            return clob.getAsciiStream();
        }
        return null;
    }

    public Reader getClobAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob != null) {
            return clob.getCharacterStream();
        }
        return null;
    }

    public LobCreator getLobCreator() {
        return new OracleLobCreator();
    }

    protected static interface LobCallback {
        public void populateLob(Object var1) throws Exception;
    }

    protected class OracleLobCreator
    implements LobCreator {
        private final List createdLobs = new LinkedList();

        protected OracleLobCreator() {
        }

        public void setBlobAsBytes(PreparedStatement ps, int paramIndex, final byte[] content) throws SQLException {
            if (content != null) {
                Blob blob = (Blob)this.createLob(ps, AnyframeOracle8iLobHandler.this.blobClass, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getBinaryOutputStream", new Class[0]);
                        OutputStream out = (OutputStream)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy((byte[])content, (OutputStream)out);
                    }
                });
                ps.setBlob(paramIndex, blob);
            } else {
                ps.setBlob(paramIndex, (Blob)null);
            }
        }

        public void setBlobAsBinaryStream(PreparedStatement ps, int paramIndex, final InputStream binaryStream, int contentLength) throws SQLException {
            if (binaryStream != null) {
                Blob blob = (Blob)this.createLob(ps, AnyframeOracle8iLobHandler.this.blobClass, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getBinaryOutputStream", null);
                        OutputStream out = (OutputStream)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy((InputStream)binaryStream, (OutputStream)out);
                    }
                });
                ps.setBlob(paramIndex, blob);
            } else {
                ps.setBlob(paramIndex, (Blob)null);
            }
        }

        public void setClobAsString(PreparedStatement ps, int paramIndex, final String content) throws SQLException {
            if (content != null) {
                Clob clob = (Clob)this.createLob(ps, AnyframeOracle8iLobHandler.this.clobClass, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getCharacterOutputStream", null);
                        Writer writer = (Writer)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy((String)content, (Writer)writer);
                    }
                });
                ps.setClob(paramIndex, clob);
            } else {
                ps.setClob(paramIndex, (Clob)null);
            }
        }

        public void setClobAsAsciiStream(PreparedStatement ps, int paramIndex, final InputStream asciiStream, int contentLength) throws SQLException {
            if (asciiStream != null) {
                Clob clob = (Clob)this.createLob(ps, AnyframeOracle8iLobHandler.this.clobClass, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getAsciiOutputStream", null);
                        OutputStream out = (OutputStream)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy((InputStream)asciiStream, (OutputStream)out);
                    }
                });
                ps.setClob(paramIndex, clob);
            } else {
                ps.setClob(paramIndex, (Clob)null);
            }
        }

        public void setClobAsCharacterStream(PreparedStatement ps, int paramIndex, final Reader characterStream, int contentLength) throws SQLException {
            if (characterStream != null) {
                Clob clob = (Clob)this.createLob(ps, AnyframeOracle8iLobHandler.this.clobClass, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getCharacterOutputStream", null);
                        Writer writer = (Writer)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy((Reader)characterStream, (Writer)writer);
                    }
                });
                ps.setClob(paramIndex, clob);
            } else {
                ps.setClob(paramIndex, (Clob)null);
            }
        }

        protected Object createLob(PreparedStatement ps, Class lobClass, LobCallback callback) throws SQLException {
            try {
                Object lob = this.prepareLob(this.getOracleConnection(ps), lobClass);
                callback.populateLob(lob);
                lob.getClass().getMethod("close", null).invoke(lob, (Object[])null);
                this.createdLobs.add(lob);
                return lob;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof SQLException) {
                    throw (SQLException)ex.getTargetException();
                }
                throw new RuntimeException("Query Service : Could not create Oracle LOB", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new RuntimeException("Query Service : Could not create Oracle LOB", ex);
            }
        }

        protected Connection getOracleConnection(PreparedStatement ps) throws SQLException, ClassNotFoundException {
            Connection conToUse = null;
            conToUse = AnyframeOracle8iLobHandler.this.nativeJdbcExtractor != null ? AnyframeOracle8iLobHandler.this.nativeJdbcExtractor.getNativeConnectionFromStatement((Statement)ps) : ps.getConnection();
            if (!AnyframeOracle8iLobHandler.this.connectionClass.isAssignableFrom(conToUse.getClass())) {
                throw new RuntimeException("Query Service : OracleLobCreator needs to work on [oracle.jdbc.OracleConnection], not on [" + conToUse.getClass() + "] - specify a corresponding NativeJdbcExtractor");
            }
            return conToUse;
        }

        protected Object prepareLob(Connection con, Class lobClass) throws Exception {
            Method createTemporary = lobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = AnyframeOracle8iLobHandler.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            Object lob = createTemporary.invoke(null, con, AnyframeOracle8iLobHandler.this.cache, AnyframeOracle8iLobHandler.this.durationSessionConstants.get(lobClass));
            Method open = lobClass.getMethod("open", Integer.TYPE);
            open.invoke(lob, AnyframeOracle8iLobHandler.this.modeReadWriteConstants.get(lobClass));
            return lob;
        }

        public void close() {
            try {
                Iterator it = this.createdLobs.iterator();
                while (it.hasNext()) {
                    Object lob = it.next();
                    Method freeTemporary = lob.getClass().getMethod("freeTemporary", new Class[0]);
                    freeTemporary.invoke(lob, new Object[0]);
                    it.remove();
                }
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                throw new RuntimeException("Query Service : Could not free Oracle LOB", ex);
            }
        }
    }
}

