/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.mapper;

import anyframe.common.util.StringUtil;
import anyframe.core.query.IMappingInfo;
import anyframe.core.query.IQueryService;
import anyframe.core.query.IResultSetMapper;
import anyframe.core.query.IRowCallbackHandler;
import anyframe.core.query.impl.jdbc.mapper.ReflectionResultSetMapper;
import anyframe.core.query.impl.util.NameMatcher;
import anyframe.core.query.impl.util.SQLTypeTransfer;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.springframework.core.CollectionFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.LobHandler;

public class CallbackResultSetMapper
extends ReflectionResultSetMapper
implements RowMapper,
IRowCallbackHandler {
    private List objects = new ArrayList();
    private Class targetClass = null;
    private String mappingStyle = null;
    private int columnCount = 0;
    private String[] columnKeys = null;
    private int[] columnTypes = null;
    private int[] columnPrecisions = null;
    private int[] columnSacles = null;
    private String[] columnNames = null;
    private boolean initialized = false;
    private IResultSetMapper customResultSetMapper = null;
    static /* synthetic */ Class class$java$util$HashMap;

    public CallbackResultSetMapper(Class targetClass, IMappingInfo mappingInfo, LobHandler lobHandler, Map nullchecks, String mappingStyle) {
        super(targetClass, mappingInfo, nullchecks, lobHandler);
        this.targetClass = targetClass;
        this.mappingStyle = mappingStyle;
        this.setNameMatcher(new InternalNameMatcher());
    }

    public Object mapRow(ResultSet resultSet, int rowNum) throws SQLException {
        if (this.customResultSetMapper != null) {
            return this.customResultSetMapper.mapRow(resultSet);
        }
        if (Map.class.isAssignableFrom(this.targetClass)) {
            return this.generateMap(resultSet);
        }
        return this.mapRow(resultSet);
    }

    private void makeMeta(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.columnCount = resultSetMetaData.getColumnCount();
        this.columnKeys = new String[this.columnCount];
        this.columnNames = new String[this.columnCount];
        this.columnTypes = new int[this.columnCount];
        this.columnPrecisions = new int[this.columnCount];
        this.columnSacles = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnLabel(i + 1);
            int columnType = resultSetMetaData.getColumnType(i + 1);
            this.columnNames[i] = columnName;
            this.columnKeys[i] = this.changeColumnName(columnName);
            int dataType = SQLTypeTransfer.UNDEFINED;
            try {
                if (columnName != null && this.targetClass != null && !this.targetClass.equals(class$java$util$HashMap == null ? CallbackResultSetMapper.class$("java.util.HashMap") : class$java$util$HashMap) && this.getMappingInfo() != null) {
                    String attributeName = (String)this.getMappingInfo().getMappingInfoAsMap().get(columnName);
                    if (attributeName == null) continue;
                    Field attribute = this.targetClass.getDeclaredField(attributeName);
                    dataType = SQLTypeTransfer.getSQLType(attribute.getType());
                }
            }
            catch (NoSuchFieldException e) {
                IQueryService.LOGGER.warn((Object)("Query Service : Fail to find a mapping attribute with '" + columnName + "' column in a target class [" + this.targetClass + ".]"));
            }
            if (!(dataType == 12 && columnType == 2005 || dataType == -3 && columnType == 2004 || dataType == SQLTypeTransfer.UNDEFINED)) {
                columnType = dataType;
            }
            this.columnTypes[i] = columnType;
            try {
                this.columnPrecisions[i] = resultSetMetaData.getPrecision(i + 1);
            }
            catch (NumberFormatException e) {
                this.columnPrecisions[i] = 0;
            }
            this.columnSacles[i] = resultSetMetaData.getScale(i + 1);
        }
        this.initialized = true;
    }

    public Object generateMap(ResultSet resultSet) throws SQLException {
        if (!this.initialized) {
            this.processMetaData(resultSet);
        }
        Map mapOfColValues = this.createColumnMap(this.columnCount);
        for (int i = 1; i <= this.columnCount; ++i) {
            String key = this.columnKeys[i - 1];
            Object obj = this.getValue(resultSet, this.columnTypes[i - 1], this.columnNames[i - 1]);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    public Map getColumnInfo() {
        ListOrderedMap colInfo = new ListOrderedMap();
        for (int i = 0; i < this.columnCount; ++i) {
            colInfo.put((Object)this.columnKeys[i], (Object)(SQLTypeTransfer.getSQLTypeName(this.columnTypes[i]) + ":" + this.columnPrecisions[i] + ":" + this.columnSacles[i]));
        }
        return colInfo;
    }

    protected Map createColumnMap(int initialCapacity) {
        return CollectionFactory.createLinkedCaseInsensitiveMapIfPossible((int)initialCapacity);
    }

    public void processRow(ResultSet resultSet) throws SQLException {
        this.objects.add(this.mapRow(resultSet, 9999));
    }

    public List getObjects() {
        return this.objects;
    }

    public void processMetaData(ResultSet resultSet) throws SQLException {
        this.makeMeta(resultSet);
    }

    public void setCustomResultSetMapper(IResultSetMapper customResultSetMapper) {
        this.customResultSetMapper = customResultSetMapper;
    }

    private String changeColumnName(String columnName) {
        if (this.mappingStyle.equals("camel")) {
            return StringUtil.convertToCamelCase((String)columnName);
        }
        if (this.mappingStyle.equals("lower")) {
            return columnName.toLowerCase();
        }
        if (this.mappingStyle.equals("upper")) {
            return columnName.toUpperCase();
        }
        return columnName;
    }

    class InternalNameMatcher
    extends NameMatcher {
        InternalNameMatcher() {
        }

        public boolean isMatching(String attributeName, String columnName, String parentAttributeName) {
            String mappedAttribute = null;
            if (CallbackResultSetMapper.this.getMappingInfo() != null && StringUtil.isEmpty((String)(mappedAttribute = (String)CallbackResultSetMapper.this.getMappingInfo().getMappingInfoAsMap().get(columnName))) && parentAttributeName != null) {
                String[] columns = (String[])CallbackResultSetMapper.this.getMappingInfo().getCompositeColumnNames().get(parentAttributeName);
                String[] attributes = (String[])CallbackResultSetMapper.this.getMappingInfo().getCompositeFieldNames().get(parentAttributeName);
                for (int i = 0; i < columns.length; ++i) {
                    if (!columnName.equals(columns[i])) continue;
                    mappedAttribute = attributes[i];
                    break;
                }
            }
            if (StringUtil.isEmpty(mappedAttribute)) {
                mappedAttribute = CallbackResultSetMapper.this.changeColumnName(columnName);
            }
            if (StringUtil.isEmpty(mappedAttribute)) {
                return false;
            }
            return mappedAttribute.equals(attributeName);
        }

        public void setFieldPrefix(String fieldPrefix) {
        }

        public void setFieldSuffix(String fieldSuffix) {
        }
    }
}

