/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.mapper;

import anyframe.core.query.IMappingInfo;
import anyframe.core.query.IQueryService;
import anyframe.core.query.impl.jdbc.mapper.ResultSetMapperSupport;
import anyframe.core.query.impl.util.ReflectionHelp;
import anyframe.core.query.impl.util.SQLTypeTransfer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.jdbc.support.lob.LobHandler;

public class ReflectionResultSetMapper
extends ResultSetMapperSupport {
    protected static final int PROPERTY_NOT_FOUND = -1;
    private List targetClasses;
    private List aggregateClasses = new ArrayList();
    private HashMap classConfigMap = new HashMap();
    private IMappingInfo mappingInfo = null;

    public ReflectionResultSetMapper(Class targetClass, IMappingInfo mappingInfo, Map nullchecks, LobHandler lobHandler) {
        super(nullchecks, lobHandler);
        this.mappingInfo = mappingInfo;
        this.targetClasses = new ArrayList();
        this.targetClasses.add(targetClass);
    }

    public void setAggregateTargets(List aggregateTargetClasses) {
        this.aggregateClasses = aggregateTargetClasses;
    }

    public IMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    public Object mapRow(ResultSet resultSet) throws SQLException {
        Object object = null;
        Iterator targetClassIterator = this.targetClasses.iterator();
        while (targetClassIterator.hasNext() && object == null) {
            Class targetClass = (Class)targetClassIterator.next();
            object = this.toObject(resultSet, targetClass);
        }
        return object;
    }

    private Object toObject(ResultSet resultSet, Class targetClass) throws SQLException {
        Object object = null;
        ClassConfiguration config = this.getConfig(targetClass, resultSet.getMetaData());
        object = this.createObject(resultSet, targetClass, config);
        if (!config.getCompositeObjMap().isEmpty()) {
            Map compositeObjMap = config.getCompositeObjMap();
            Set keySet = compositeObjMap.keySet();
            Iterator keyItr = keySet.iterator();
            while (keyItr.hasNext()) {
                String attribute = (String)keyItr.next();
                ClassConfiguration subconfiguration = (ClassConfiguration)config.getCompositeObjMap().get(attribute);
                Object compositeObj = this.createObject(resultSet, subconfiguration.getResultClass(), subconfiguration);
                try {
                    subconfiguration.getCompositeClassSetter().invoke(object, compositeObj);
                }
                catch (Exception e) {
                    IQueryService.LOGGER.warn((Object)("Query Service : Fail to invoke setter['" + subconfiguration.getCompositeClassSetter().getName() + "'] of target class['" + targetClass.getName() + "']."), (Throwable)e);
                }
            }
        }
        return object;
    }

    private void mapAggregateTargets(ResultSet resultSet, Object object) throws SQLException {
        Class<?> targetClass = object.getClass();
        Iterator fieldIterator = ReflectionHelp.getFields(object).iterator();
        while (fieldIterator.hasNext()) {
            Field field = (Field)fieldIterator.next();
            Method setter = this.findSetter(targetClass, field);
            Class<?> aggregateClass = field.getType();
            if (!this.aggregateClasses.contains(aggregateClass)) continue;
            ReflectionResultSetMapper resultSetMapper = new ReflectionResultSetMapper(aggregateClass, this.mappingInfo, this.getNullchecks(), this.getLobHandler());
            resultSetMapper.setNameMatcher(this.getNameMatcher());
            resultSetMapper.setObjectValidator(this.getObjectValidator());
            Object aggregateObject = resultSetMapper.mapRow(resultSet);
            if (aggregateObject == null) continue;
            resultSetMapper.mapAggregateTargets(resultSet, aggregateObject);
            this.setValue(field, setter, object, aggregateObject);
        }
    }

    protected ClassConfiguration getConfig(Class targetClass, ResultSetMetaData resultSetMetaData) throws SQLException {
        ClassConfiguration classConfiguration;
        if (this.classConfigMap.containsKey(targetClass)) {
            classConfiguration = (ClassConfiguration)this.classConfigMap.get(targetClass);
        } else {
            AccessibleObject[] attributes = ReflectionHelp.getAllDeclaredFields(targetClass);
            AccessibleObject.setAccessible(attributes, true);
            classConfiguration = this.mapColumnsToAttributes(targetClass, resultSetMetaData, (Field[])attributes, null);
            this.classConfigMap.put(targetClass, classConfiguration);
        }
        return classConfiguration;
    }

    private ClassConfiguration mapColumnsToAttributes(Class targetClass, ResultSetMetaData resultSetMetaData, Field[] attributes, String parentAttribute) throws SQLException {
        int totalCols = resultSetMetaData.getColumnCount();
        int[] columnToAttributes = new int[totalCols];
        String[] columnNames = new String[totalCols];
        int[] columnTypes = new int[totalCols];
        Method[] setters = new Method[totalCols];
        HashMap<String, ClassConfiguration> compositeObjMap = new HashMap<String, ClassConfiguration>();
        Arrays.fill(columnToAttributes, -1);
        Map compositeFields = this.mappingInfo.getCompositeFieldNames();
        block2: for (int idx = 0; idx < totalCols; ++idx) {
            String columnName = resultSetMetaData.getColumnName(idx + 1);
            int columnType = resultSetMetaData.getColumnType(idx + 1);
            for (int i = 0; i < attributes.length; ++i) {
                if (compositeFields != null && compositeFields.containsKey(attributes[i].getName())) {
                    Method compositeClassSetter = null;
                    try {
                        compositeClassSetter = this.findSetter(targetClass, targetClass.getDeclaredField(attributes[i].getName()));
                    }
                    catch (NoSuchFieldException nse) {
                        IQueryService.LOGGER.warn((Object)("Query Service : Fail to find a attribute['" + attributes[i].getName() + "'] from target class['" + targetClass.getName() + "']."), (Throwable)nse);
                        continue block2;
                    }
                    AccessibleObject[] childAttributes = ReflectionHelp.getAllDeclaredFields(attributes[i].getType());
                    AccessibleObject.setAccessible(childAttributes, true);
                    ClassConfiguration subconfigurations = this.mapColumnsToAttributes(attributes[i].getType(), resultSetMetaData, (Field[])childAttributes, attributes[i].getName());
                    subconfigurations.setResultClass(attributes[i].getType());
                    subconfigurations.setCompositeClassSetter(compositeClassSetter);
                    compositeObjMap.put(attributes[i].getName(), subconfigurations);
                    continue;
                }
                if (!this.getNameMatcher().isMatching(attributes[i].getName(), columnName, parentAttribute)) continue;
                columnToAttributes[idx] = i;
                columnNames[idx] = columnName;
                int dataType = SQLTypeTransfer.getSQLType(attributes[i].getType());
                if (!(dataType == 12 && columnType == 2005 || dataType == -3 && columnType == 2004 || dataType == SQLTypeTransfer.UNDEFINED)) {
                    columnType = dataType;
                }
                columnTypes[idx] = columnType;
                setters[idx] = this.findSetter(targetClass, attributes[i]);
                continue block2;
            }
        }
        return new ClassConfiguration(columnToAttributes, columnNames, columnTypes, attributes, setters, compositeObjMap);
    }

    private Method findSetter(Class targetClass, Field field) {
        try {
            String tempMethodName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
            return targetClass.getMethod("set" + tempMethodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Object createObject(ResultSet resultSet, Class targetClass, ClassConfiguration config) throws SQLException {
        Object object = ReflectionHelp.newInstance(targetClass);
        int[] columnToAttributes = config.getColumnToAttributes();
        String[] columnNames = config.getColumnNames();
        int[] columnTypes = config.getColumnTypes();
        Field[] attributes = config.getAttributes();
        Method[] setters = config.getSetters();
        for (int i = 0; i < columnToAttributes.length; ++i) {
            if (columnToAttributes[i] == -1) continue;
            int columnType = columnTypes[i];
            Object value = this.getValue(resultSet, columnType, columnNames[i]);
            this.setValue(attributes[columnToAttributes[i]], setters[i], object, value);
        }
        return object;
    }

    private void setValue(Field field, Method setter, Object object, Object value) {
        if (value != null) {
            boolean valueSet = false;
            try {
                if (setter != null) {
                    setter.invoke(object, value);
                    valueSet = true;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Query Service : Fail to invoke a setter method ['" + setter.getName() + "'. Reason : " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Query Service : Fail to invoke a setter method ['" + setter.getName() + "'. Reason : " + e.getMessage(), e);
            }
            if (!valueSet) {
                ReflectionHelp.setFieldValue(field, object, value);
            }
        }
    }

    protected class ClassConfiguration {
        private int[] columnToAttributes;
        private String[] columnNames;
        private int[] columnTypes;
        private Field[] attributes;
        private Method[] setters;
        private Map compositeObjMap;
        private Class resultClass;
        private Method compositeClassSetter;

        ClassConfiguration(int[] columnToAttributes, String[] columnNames, int[] columnTypes, Field[] attributes, Method[] setters, Map compositeObjMap) {
            this.columnToAttributes = columnToAttributes;
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
            this.attributes = attributes;
            this.setters = setters;
            this.compositeObjMap = compositeObjMap;
        }

        public int[] getColumnToAttributes() {
            return this.columnToAttributes;
        }

        public int[] getColumnTypes() {
            return this.columnTypes;
        }

        public Method[] getSetters() {
            return this.setters;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public Field[] getAttributes() {
            return this.attributes;
        }

        public Map getCompositeObjMap() {
            return this.compositeObjMap;
        }

        public Method getCompositeClassSetter() {
            return this.compositeClassSetter;
        }

        public void setCompositeClassSetter(Method compositeClassSetter) {
            this.compositeClassSetter = compositeClassSetter;
        }

        public Class getResultClass() {
            return this.resultClass;
        }

        public void setResultClass(Class resultClass) {
            this.resultClass = resultClass;
        }
    }
}

