/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.mapper;

import anyframe.core.query.IQueryService;
import anyframe.core.query.IResultSetMapper;
import anyframe.core.query.QueryServiceException;
import anyframe.core.query.impl.util.DefaultObjectValidator;
import anyframe.core.query.impl.util.IClassValidator;
import anyframe.core.query.impl.util.IObjectValidator;
import anyframe.core.query.impl.util.NameConverter;
import anyframe.core.query.impl.util.NameMatcher;
import java.sql.ResultSet;
import java.util.Map;
import org.springframework.jdbc.support.lob.LobHandler;

public abstract class ResultSetMapperSupport
implements IResultSetMapper {
    private static NameMatcher defaultNameMatcher = new NameConverter();
    private static IObjectValidator defaultObjectValidator = new DefaultObjectValidator();
    private NameMatcher nameMatcher;
    private IObjectValidator objectValidator;
    private Map nullchecks;
    private LobHandler lobHandler;

    public ResultSetMapperSupport(Map nullchecks, LobHandler lobHandler) {
        this.nullchecks = nullchecks;
        this.lobHandler = lobHandler;
        this.objectValidator = defaultObjectValidator;
        this.nameMatcher = defaultNameMatcher;
    }

    public final void setNameMatcher(NameMatcher nameMatcher) {
        this.nameMatcher = nameMatcher;
    }

    public final void setObjectValidator(IObjectValidator objectValidator) {
        this.objectValidator = objectValidator;
    }

    public NameMatcher getNameMatcher() {
        return this.nameMatcher;
    }

    public IObjectValidator getObjectValidator() {
        return this.objectValidator;
    }

    public Map getNullchecks() {
        return this.nullchecks;
    }

    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setNullCheckInfos(Map nullCheckInfos) {
        this.nullchecks = nullCheckInfos;
    }

    protected boolean isValid(Object object) {
        if (object instanceof IClassValidator) {
            return ((IClassValidator)object).isValid();
        }
        return this.objectValidator.isValid(object);
    }

    protected Object getValue(ResultSet resultSet, int columnType, String columnName) {
        try {
            switch (columnType) {
                case 2003: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - ARRAY. Column Name - " + columnName + ".");
                }
                case -5: {
                    return new Long(resultSet.getLong(columnName));
                }
                case -2: {
                    return resultSet.getBytes(columnName);
                }
                case -7: {
                    return new Boolean(resultSet.getBoolean(columnName));
                }
                case 1: {
                    Object obj = resultSet.getString(columnName);
                    if (obj == null && this.nullchecks.size() != 0) {
                        obj = this.changeNullValue("char");
                    }
                    return obj;
                }
                case 2005: {
                    return this.lobHandler.getClobAsString(resultSet, columnName);
                }
                case 2004: {
                    return this.lobHandler.getBlobAsBytes(resultSet, columnName);
                }
                case 91: {
                    return resultSet.getDate(columnName);
                }
                case 3: {
                    return resultSet.getBigDecimal(columnName);
                }
                case 2001: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - DISTINCT. Column Name - " + columnName + ".");
                }
                case 8: {
                    return new Double(resultSet.getDouble(columnName));
                }
                case 6: {
                    return new Double(resultSet.getDouble(columnName));
                }
                case 4: {
                    return new Integer(resultSet.getInt(columnName));
                }
                case 2000: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - JAVA_OBJECT. Column Name - " + columnName + ".");
                }
                case -4: {
                    return resultSet.getBytes(columnName);
                }
                case -1: {
                    Object obj = resultSet.getString(columnName);
                    if (obj == null && this.nullchecks.size() != 0) {
                        obj = this.changeNullValue("longvarchar");
                    }
                    return obj;
                }
                case 0: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - NULL. Column Name - " + columnName + ".");
                }
                case 2: {
                    return resultSet.getBigDecimal(columnName);
                }
                case 1111: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - OTHER. Column Name - " + columnName + ".");
                }
                case 7: {
                    return new Float(resultSet.getFloat(columnName));
                }
                case 2006: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - REF. Column Name - " + columnName + ".");
                }
                case 5: {
                    return new Short(resultSet.getShort(columnName));
                }
                case 2002: {
                    throw new QueryServiceException("Query Service : Not supported SQL type. Column Type - STRUCT. Column Name - " + columnName + ".");
                }
                case 92: {
                    return resultSet.getTime(columnName);
                }
                case 93: {
                    return resultSet.getTimestamp(columnName);
                }
                case -6: {
                    return new Byte(resultSet.getByte(columnName));
                }
                case -3: {
                    return resultSet.getBytes(columnName);
                }
                case 12: {
                    Object obj = resultSet.getString(columnName);
                    if (obj == null && this.nullchecks.size() != 0) {
                        obj = this.changeNullValue("varchar");
                    }
                    return obj;
                }
            }
            return resultSet.getString(columnName);
        }
        catch (Exception e) {
            IQueryService.LOGGER.error((Object)("Query Service : Not supported SQL type. Column Name - " + columnName + "."), (Throwable)e);
            return null;
        }
    }

    private Object changeNullValue(String type) {
        if (this.nullchecks.containsKey(type)) {
            return this.nullchecks.get(type);
        }
        return null;
    }
}

