/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.setter;

import anyframe.core.query.ISqlParameterSource;
import anyframe.core.query.impl.util.NameConverter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ExtMapSqlParameterSource
extends MapSqlParameterSource
implements ISqlParameterSource {
    private final Map sqlTypes = new HashMap();

    public ExtMapSqlParameterSource() {
    }

    public ExtMapSqlParameterSource(Map properties) {
        super(properties);
    }

    public Object getValue(String paramName) {
        Object value = this.getVariableFromContext(paramName);
        return value;
    }

    public Object[] getKeys() {
        Map values = this.getValues();
        Object[] keys = new Object[values.size()];
        if (keys.length != 0) {
            int i = 0;
            Iterator keyIterator = values.keySet().iterator();
            if (keyIterator != null) {
                keys[i++] = keyIterator.next();
            }
        }
        return keys;
    }

    private Object getVariableFromContext(String variable) {
        Object valuesMap = this.getValues();
        String[] strArray = ExtMapSqlParameterSource.convertDelimitedStringToStringArray(variable, ".");
        for (int i = 0; i < strArray.length; ++i) {
            String str = strArray[i];
            try {
                valuesMap = ExtMapSqlParameterSource.getProperty(valuesMap, str);
                continue;
            }
            catch (Exception e) {
                valuesMap = null;
            }
        }
        return valuesMap;
    }

    public static Object getProperty(Object obj, String propertyName) throws Exception {
        if (obj instanceof Map) {
            return ((Map)obj).get(propertyName);
        }
        Class[] paramTypes = new Class[]{};
        Object[] args = new Object[]{};
        Object result = null;
        String methodName = ExtMapSqlParameterSource.buildPropertyGetterName(propertyName);
        Method method = obj.getClass().getMethod(methodName, paramTypes);
        result = method.invoke(obj, args);
        return result;
    }

    protected static String buildPropertyGetterName(String propertyName) {
        if (propertyName.endsWith("()")) {
            return propertyName.substring(0, propertyName.length() - 2);
        }
        return ExtMapSqlParameterSource.buildPropertyMethodName("get", propertyName);
    }

    protected static String buildPropertySetterName(String propertyName) {
        return ExtMapSqlParameterSource.buildPropertyMethodName("set", propertyName);
    }

    protected static String buildPropertyMethodName(String prefix, String propertyName) {
        StringBuffer strBuffer = new StringBuffer(prefix);
        strBuffer.append(NameConverter.capitalise(propertyName));
        return strBuffer.toString();
    }

    public static String[] convertDelimitedStringToStringArray(String str, String delimiter) {
        StringTokenizer strTokenizer = new StringTokenizer(str, delimiter);
        int length = strTokenizer.countTokens();
        String[] strArray = new String[length];
        int i = 0;
        while (strTokenizer.hasMoreTokens()) {
            strArray[i] = strTokenizer.nextToken().trim();
            ++i;
        }
        return strArray;
    }

    public void addSqlType(String paramName, int sqlType) {
        this.sqlTypes.put(paramName, new Integer(sqlType));
    }

    public int getSqlType(String paramName) {
        Integer sqlType = (Integer)this.sqlTypes.get(paramName);
        if (sqlType != null) {
            return sqlType;
        }
        return Integer.MIN_VALUE;
    }
}

