/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc.setter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.lob.LobHandler;

public class PreparedStatementArgTypeSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;
    private LobHandler lobHandler;

    public PreparedStatementArgTypeSetter(Object[] args, int[] argTypes, LobHandler lobHandler) {
        if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
            throw new InvalidDataAccessApiUsageException("Query Service : args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
        this.lobHandler = lobHandler;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        block8: {
            int argIndx = 1;
            if (this.args == null) break block8;
            if (this.argTypes == null) {
                for (int i = 0; i < this.args.length; ++i) {
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, null, (Object)this.args[i]);
                }
            } else {
                for (int i = 0; i < this.args.length; ++i) {
                    Object arg = this.args[i];
                    if (arg instanceof Collection && this.argTypes[i] != 2003) {
                        Collection entries = (Collection)arg;
                        Iterator it = entries.iterator();
                        while (it.hasNext()) {
                            Object entry = it.next();
                            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)argIndx++, (int)this.argTypes[i], null, entry);
                        }
                        continue;
                    }
                    if (this.argTypes[i] == 2004) {
                        this.lobHandler.getLobCreator().setBlobAsBytes(ps, argIndx++, (byte[])arg);
                        continue;
                    }
                    if (this.argTypes[i] == 2005) {
                        this.lobHandler.getLobCreator().setClobAsString(ps, argIndx++, (String)arg);
                        continue;
                    }
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)argIndx++, (int)this.argTypes[i], null, (Object)arg);
                }
            }
        }
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters((Object[])this.args);
    }
}

