/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.util;

import anyframe.core.query.impl.util.NameMatcher;

public class NameConverter
extends NameMatcher {
    private String prefix = "";
    private String suffix = "";

    public static String capitalise(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public boolean isMatching(String fieldName, String columnName, String parentFieldName) {
        return columnName.equalsIgnoreCase(this.prefix.concat(NameConverter.convertToUnderScore(fieldName)).concat(this.suffix));
    }

    public static String convertToUnderScore(String camelCaseStr) {
        String result = "";
        for (int i = 0; i < camelCaseStr.length(); ++i) {
            char currentChar = camelCaseStr.charAt(i);
            if (i > 0 && Character.isUpperCase(currentChar)) {
                result = result.concat("_");
            }
            result = result.concat(Character.toString(currentChar).toLowerCase());
        }
        return result;
    }

    public static String convertToCamelCase(String originalString, char searchChar) {
        String result = "";
        boolean nextUpper = false;
        for (int i = 0; i < originalString.length(); ++i) {
            char currentChar = originalString.charAt(i);
            if (currentChar == searchChar) {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                currentChar = Character.toUpperCase(currentChar);
                nextUpper = false;
            }
            result = result.concat(Character.toString(currentChar));
        }
        return result;
    }

    public static String convertToCamelCase(String underScore) {
        String result = "";
        boolean nextUpper = false;
        String allLower = underScore.toLowerCase();
        for (int i = 0; i < allLower.length(); ++i) {
            char currentChar = allLower.charAt(i);
            if (currentChar == '_') {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                currentChar = Character.toUpperCase(currentChar);
                nextUpper = false;
            }
            result = result.concat(Character.toString(currentChar));
        }
        return result;
    }

    public void setFieldPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    public void setFieldSuffix(String suffix) {
        this.suffix = suffix == null ? "" : suffix;
    }

    public static String deCapitalise(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

