/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ReflectionHelp {
    private ReflectionHelp() {
    }

    public static Field[] getAllDeclaredFields(Class target) {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        if (target.getSuperclass() != null) {
            Field[] allFields = ReflectionHelp.getAllDeclaredFields(target.getSuperclass());
            fieldList.addAll(Arrays.asList(allFields));
        }
        Field[] currentFields = target.getDeclaredFields();
        fieldList.addAll(Arrays.asList(currentFields));
        return fieldList.toArray(new Field[fieldList.size()]);
    }

    public static List getFields(Object obj) {
        AccessibleObject[] fields = ReflectionHelp.getAllDeclaredFields(obj.getClass());
        AccessibleObject.setAccessible(fields, true);
        List<AccessibleObject> fieldList = Arrays.asList(fields);
        return fieldList;
    }

    public static void setFieldValue(Field field, Object obj, Object value) {
        try {
            if (value != null) {
                field.set(obj, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Query Service : Cannot set " + field.getName() + " = (" + value + ") Reason : " + e.getMessage());
        }
    }

    public static Object getFieldValue(Field field, Object bean) {
        try {
            return field.get(bean);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Query Service : Cannot get " + field.getName() + ", Reason : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Query Service : Cannot get " + field.getName() + ", Reason : " + e.getMessage());
        }
    }

    public static Object newInstance(Class createClass) {
        try {
            return createClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Query Service : Cannot create " + createClass.getName() + ", Reason : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Query Service : Cannot create " + createClass.getName() + ", Reason : " + e.getMessage());
        }
    }
}

