/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.util;

import anyframe.core.query.IQueryService;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;

public class SQLTypeTransfer {
    private static HashMap sqltypenames = new HashMap();
    private static HashMap sqltypes = new HashMap();
    private static HashMap javatypes = new HashMap();
    public static int UNDEFINED = -1;

    private SQLTypeTransfer() {
    }

    public static int getSQLType(String typeName) {
        int retValue = -1;
        if (sqltypes.containsKey(typeName)) {
            try {
                retValue = (Integer)sqltypes.get(typeName);
            }
            catch (Exception e) {
                IQueryService.LOGGER.error((Object)("Query Service : Not supported sql type. [" + typeName + "]" + e.getStackTrace().toString()));
            }
        }
        return retValue;
    }

    public static int getSQLType(Class clazz) {
        int retValue = UNDEFINED;
        if (javatypes.containsKey(clazz)) {
            try {
                retValue = (Integer)javatypes.get(clazz);
            }
            catch (Exception e) {
                IQueryService.LOGGER.error((Object)("Query Service : Not supported java type. [" + clazz.getName() + "]" + e.getStackTrace().toString()));
            }
        }
        return retValue;
    }

    public static List getSqlParameterList(String[] paramTypeNames, String[] paramBindingTypes, String[] paramBindingNames) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < paramTypeNames.length; ++i) {
            int type = SQLTypeTransfer.getSQLType(paramTypeNames[i].toUpperCase());
            if ("IN".equals(paramBindingTypes[i].toUpperCase())) {
                list.add(new SqlParameter(paramBindingNames[i], type, paramTypeNames[i]));
                continue;
            }
            if ("OUT".equals(paramBindingTypes[i].toUpperCase())) {
                if ("CURSOR".equals(paramTypeNames[i].toUpperCase()) || "OTHER".equals(paramTypeNames[i].toUpperCase())) {
                    list.add(new SqlOutParameter(paramBindingNames[i], type, (RowMapper)new ColumnMapRowMapper()));
                    continue;
                }
                list.add(new SqlOutParameter(paramBindingNames[i], type, paramTypeNames[i]));
                continue;
            }
            if ("INOUT".equals(paramBindingTypes[i].toUpperCase())) {
                if ("CURSOR".equals(paramTypeNames[i].toUpperCase()) || "OTHER".equals(paramTypeNames[i].toUpperCase())) {
                    list.add(new SqlOutParameter(paramBindingNames[i], type, (RowMapper)new ColumnMapRowMapper()));
                    continue;
                }
                list.add(new SqlOutParameter(paramBindingNames[i], type, paramTypeNames[i]));
                continue;
            }
            list.add(new SqlParameter(paramBindingNames[i], type, paramTypeNames[i]));
        }
        return list;
    }

    public static String getSQLTypeName(int type) {
        String retValue = "";
        if (sqltypenames.containsKey(new Integer(type))) {
            try {
                retValue = (String)sqltypenames.get(new Integer(type));
            }
            catch (Exception e) {
                IQueryService.LOGGER.error((Object)("Query Service : Not supported sql type. [" + type + "]" + e.getStackTrace().toString()));
            }
        }
        return retValue;
    }

    static {
        javatypes.put(String.class, new Integer(12));
        javatypes.put(BigDecimal.class, new Integer(2));
        javatypes.put(Boolean.TYPE, new Integer(-7));
        javatypes.put(Byte.TYPE, new Integer(-6));
        javatypes.put(Short.TYPE, new Integer(5));
        javatypes.put(Integer.TYPE, new Integer(4));
        javatypes.put(Long.TYPE, new Integer(-5));
        javatypes.put(Float.TYPE, new Integer(7));
        javatypes.put(Double.TYPE, new Integer(8));
        javatypes.put([B.class, new Integer(-3));
        javatypes.put(Date.class, new Integer(91));
        javatypes.put(Time.class, new Integer(92));
        javatypes.put(Timestamp.class, new Integer(93));
        javatypes.put(Double.class, new Integer(8));
        javatypes.put(Long.class, new Integer(-5));
        sqltypes.put("ARRAY", new Integer(2003));
        sqltypes.put("BIGINT", new Integer(-5));
        sqltypes.put("BINARY", new Integer(-2));
        sqltypes.put("BIT", new Integer(-7));
        sqltypes.put("BLOB", new Integer(2004));
        sqltypes.put("CHAR", new Integer(1));
        sqltypes.put("CLOB", new Integer(2005));
        sqltypes.put("DATE", new Integer(91));
        sqltypes.put("DECIMAL", new Integer(3));
        sqltypes.put("DISTINCT", new Integer(2001));
        sqltypes.put("DOUBLE", new Integer(8));
        sqltypes.put("FLOAT", new Integer(6));
        sqltypes.put("INTEGER", new Integer(4));
        sqltypes.put("JAVA_OBJECT", new Integer(2000));
        sqltypes.put("LONGVARBINARY", new Integer(-4));
        sqltypes.put("LONGVARCHAR", new Integer(-1));
        sqltypes.put("NULL", new Integer(0));
        sqltypes.put("NUMERIC", new Integer(2));
        sqltypes.put("OTHER", new Integer(1111));
        sqltypes.put("REAL", new Integer(7));
        sqltypes.put("REF", new Integer(2006));
        sqltypes.put("SMALLINT", new Integer(5));
        sqltypes.put("STRUCT", new Integer(2002));
        sqltypes.put("TIME", new Integer(92));
        sqltypes.put("TIMESTAMP", new Integer(93));
        sqltypes.put("TINYINT", new Integer(-6));
        sqltypes.put("VARBINARY", new Integer(-3));
        sqltypes.put("VARCHAR", new Integer(12));
        sqltypes.put("ROWID", new Integer(-8));
        sqltypes.put("CURSOR", new Integer(-10));
        sqltypes.put("JAVA_STRUCT", new Integer(2008));
        sqltypes.put("JAVA_OBJECT", new Integer(2000));
        sqltypes.put("PLSQL_INDEX_TABLE", new Integer(-14));
        sqltypes.put("FIXED_CHAR", new Integer(999));
        sqltypes.put("DATALINK", new Integer(70));
        sqltypenames.put(new Integer(2003), "ARRAY");
        sqltypenames.put(new Integer(-5), "BIGINT");
        sqltypenames.put(new Integer(-2), "BINARY");
        sqltypenames.put(new Integer(-7), "BIT");
        sqltypenames.put(new Integer(2004), "BLOB");
        sqltypenames.put(new Integer(1), "CHAR");
        sqltypenames.put(new Integer(2005), "CLOB");
        sqltypenames.put(new Integer(91), "DATE");
        sqltypenames.put(new Integer(3), "DECIMAL");
        sqltypenames.put(new Integer(2001), "DISTINCT");
        sqltypenames.put(new Integer(8), "DOUBLE");
        sqltypenames.put(new Integer(6), "FLOAT");
        sqltypenames.put(new Integer(4), "INTEGER");
        sqltypenames.put(new Integer(2000), "JAVA_OBJECT");
        sqltypenames.put(new Integer(-4), "LONGVARBINARY");
        sqltypenames.put(new Integer(-1), "LONGVARCHAR");
        sqltypenames.put(new Integer(0), "NULL");
        sqltypenames.put(new Integer(2), "NUMERIC");
        sqltypenames.put(new Integer(1111), "OTHER");
        sqltypenames.put(new Integer(7), "REAL");
        sqltypenames.put(new Integer(2006), "REF");
        sqltypenames.put(new Integer(5), "SMALLINT");
        sqltypenames.put(new Integer(2002), "STRUCT");
        sqltypenames.put(new Integer(92), "TIME");
        sqltypenames.put(new Integer(93), "TIMESTAMP");
        sqltypenames.put(new Integer(-6), "TINYINT");
        sqltypenames.put(new Integer(-3), "VARBINARY");
        sqltypenames.put(new Integer(12), "VARCHAR");
        sqltypenames.put(new Integer(-8), "ROWID");
        sqltypenames.put(new Integer(-10), "CURSOR");
        sqltypenames.put(new Integer(2008), "JAVA_STRUCT");
        sqltypenames.put(new Integer(2000), "JAVA_OBJECT");
        sqltypenames.put(new Integer(-14), "PLSQL_INDEX_TABLE");
        sqltypenames.put(new Integer(999), "FIXED_CHAR");
        sqltypenames.put(new Integer(70), "DATALINK");
    }
}

