/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.util;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtils {
    private static Logger logger = LoggerFactory.getLogger(ListUtils.class);

    public static <T> String toDelimetedString(List<T> list, String delimeter) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T listItem : list) {
            sb.append(listItem);
            sb.append(delimeter);
        }
        sb.delete(sb.length() - delimeter.length(), sb.length());
        logger.debug("delimeted string: {}", (Object)sb.toString());
        return sb.toString();
    }

    public static boolean containsByAntStylePattern(List<String> patternList, String text) {
        boolean isContains = false;
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String pattern : patternList) {
            if (!antPathMatcher.match(pattern, text)) continue;
            isContains = true;
        }
        return isContains;
    }
}

