/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static boolean isLocalhost(InetAddress inetAddress) throws UnknownHostException {
        InetAddress[] inetAddressArray;
        boolean isLocalhost = false;
        String hostName = InetAddress.getLocalHost().getHostName();
        logger.info("hostName: {}", (Object)hostName);
        for (InetAddress tmpInetAddress : inetAddressArray = InetAddress.getAllByName(hostName)) {
            logger.info("hostAddress: {}", (Object)tmpInetAddress.getHostAddress());
            if (!inetAddress.equals(tmpInetAddress)) continue;
            isLocalhost = true;
        }
        return isLocalhost;
    }

    public static boolean isLocalhostByRawIpAddress(String rawIpAddress) throws UnknownHostException {
        InetAddress[] inetAddressArray;
        boolean isLocalhost = false;
        String hostName = InetAddress.getLocalHost().getHostName();
        logger.info("hostName: {}", (Object)hostName);
        for (InetAddress tmpInetAddress : inetAddressArray = InetAddress.getAllByName(hostName)) {
            logger.info("hostAddress: {}", (Object)tmpInetAddress.getHostAddress());
            if (!rawIpAddress.equals(tmpInetAddress.toString())) continue;
            isLocalhost = true;
        }
        return isLocalhost;
    }

    public static boolean isLocalhostByHostName(String hostName) throws UnknownHostException {
        InetAddress[] inetAddressArray;
        boolean isLocalhost = false;
        String localhostName = InetAddress.getLocalHost().getHostName();
        logger.info("hostName: {}", (Object)localhostName);
        for (InetAddress tmpInetAddress : inetAddressArray = InetAddress.getAllByName(localhostName)) {
            logger.info("hostAddress: {}", (Object)tmpInetAddress.getHostAddress());
            if (!hostName.equals(tmpInetAddress.getHostName())) continue;
            isLocalhost = true;
        }
        return isLocalhost;
    }
}

