/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.en;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public class AlphaNumWordFilter
extends TokenFilter {
    public static final int MAX_TOKEN_LENGTH_LIMIT = 0x100000;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    public static final int ALPHANUM = 0;
    public static final int NUM = 6;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    protected AttributeSource.State current;
    protected int maxTokenLength = 255;

    public AlphaNumWordFilter(TokenStream input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        if (this.current != null) {
            this.restoreState(this.current);
            this.current = null;
            return this.processToken();
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        return this.processToken();
    }

    private boolean processToken() throws IOException {
        String type = this.getType();
        if ("word".equals(this.typeAtt.type()) && !type.equals(this.typeAtt.type())) {
            this.typeAtt.setType(type);
        }
        int endOffset = this.offsetAtt.endOffset();
        AttributeSource.State previousState = this.captureState();
        while (this.input.incrementToken()) {
            String currentType = this.getType();
            int currentStartOffset = this.offsetAtt.startOffset();
            if (currentStartOffset != endOffset) {
                if ("word".equals(this.typeAtt.type()) && !currentType.equals(this.typeAtt.type())) {
                    this.typeAtt.setType(currentType);
                }
                this.current = this.captureState();
                break;
            }
            if ((StandardTokenizer.TOKEN_TYPES[0].equals(type) || StandardTokenizer.TOKEN_TYPES[6].equals(type)) && (StandardTokenizer.TOKEN_TYPES[0].equals(currentType) || StandardTokenizer.TOKEN_TYPES[6].equals(currentType))) {
                this.concatenateTerms(previousState);
                previousState = this.captureState();
                endOffset = this.offsetAtt.endOffset();
                continue;
            }
            if ("word".equals(this.typeAtt.type())) {
                this.typeAtt.setType(currentType);
            }
            this.current = this.captureState();
            break;
        }
        this.restoreState(previousState);
        return true;
    }

    private void concatenateTerms(AttributeSource.State previousState) {
        String term = this.termAtt.toString();
        int endOffset = this.offsetAtt.endOffset();
        String type2 = this.getType();
        this.restoreState(previousState);
        if (this.termAtt.length() < this.maxTokenLength) {
            this.termAtt.append(term);
        }
        this.offsetAtt.setOffset(this.offsetAtt.startOffset(), endOffset);
        String type1 = this.getType();
        if (StandardTokenizer.TOKEN_TYPES[6].equals(type1) && StandardTokenizer.TOKEN_TYPES[0].equals(type2)) {
            this.typeAtt.setType(StandardTokenizer.TOKEN_TYPES[0]);
        } else if (StandardTokenizer.TOKEN_TYPES[0].equals(type1) && StandardTokenizer.TOKEN_TYPES[6].equals(type2)) {
            this.typeAtt.setType(StandardTokenizer.TOKEN_TYPES[0]);
        } else if (!type1.equals(type2)) {
            this.typeAtt.setType(StandardTokenizer.TOKEN_TYPES[3]);
        } else if ("word".equals(type1)) {
            this.typeAtt.setType(type1);
        }
    }

    private String getType() {
        if (!"word".equals(this.typeAtt.type())) {
            return this.typeAtt.type();
        }
        if (this.termAtt.length() != 1) {
            return "word";
        }
        char c = this.termAtt.charAt(0);
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        if (Character.UnicodeBlock.HIRAGANA.equals(block)) {
            return StandardTokenizer.TOKEN_TYPES[4];
        }
        if (Character.UnicodeBlock.KATAKANA.equals(block) || Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS.equals(block)) {
            return StandardTokenizer.TOKEN_TYPES[5];
        }
        if (Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO.equals(block) || Character.UnicodeBlock.HANGUL_JAMO.equals(block) || Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_A.equals(block) || Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_B.equals(block) || Character.UnicodeBlock.HANGUL_SYLLABLES.equals(block)) {
            return StandardTokenizer.TOKEN_TYPES[6];
        }
        if (Character.UnicodeBlock.CJK_COMPATIBILITY.equals(block) || Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS.equals(block) || Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS.equals(block) || Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT.equals(block) || Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT.equals(block) || Character.UnicodeBlock.CJK_STROKES.equals(block) || Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.equals(block) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(block) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A.equals(block) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B.equals(block) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C.equals(block) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D.equals(block)) {
            return StandardTokenizer.TOKEN_TYPES[3];
        }
        if (Character.isAlphabetic(c)) {
            return StandardTokenizer.TOKEN_TYPES[0];
        }
        if (Character.isDigit(c)) {
            return StandardTokenizer.TOKEN_TYPES[6];
        }
        return "word";
    }

    public void setMaxTokenLength(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("maxTokenLength must be greater than zero");
        }
        if (length > 0x100000) {
            throw new IllegalArgumentException("maxTokenLength may not exceed 1048576");
        }
        if (length != this.maxTokenLength) {
            this.maxTokenLength = length;
        }
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }
}

