/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.en;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class ReloadableStopFilter
extends FilteringTokenFilter {
    private static final int INITIAL_CAPACITY = 16;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private CharArraySet stopWords;
    private final Path stopWordPath;
    private long reloadInterval;
    private long expiry;
    private boolean ignoreCase;
    private long lastModifed;

    public ReloadableStopFilter(TokenStream in, Path stopwordPath, boolean ignoreCase, long reloadInterval) {
        super(in);
        this.stopWordPath = stopwordPath;
        this.ignoreCase = ignoreCase;
        this.reloadInterval = reloadInterval;
        this.loadStopWordSet();
        this.expiry = System.currentTimeMillis() + reloadInterval;
    }

    protected boolean accept() {
        return !this.stopWords.contains(this.termAtt.buffer(), 0, this.termAtt.length());
    }

    public void reset() throws IOException {
        if (this.expiry < System.currentTimeMillis()) {
            if (Files.getLastModifiedTime(this.stopWordPath, new LinkOption[0]).toMillis() > this.lastModifed) {
                this.loadStopWordSet();
            }
            this.expiry = System.currentTimeMillis() + this.reloadInterval;
        }
        super.reset();
    }

    private void loadStopWordSet() {
        try (BufferedReader reader = Files.newBufferedReader(this.stopWordPath, Charset.forName("UTF-8"));){
            this.stopWords = WordlistLoader.getWordSet((Reader)reader, (CharArraySet)new CharArraySet(16, this.ignoreCase));
            this.lastModifed = Files.getLastModifiedTime(this.stopWordPath, new LinkOption[0]).toMillis();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read " + this.stopWordPath, e);
        }
    }
}

