/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.analysis.ja;

import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.ConcatenationFilter;

public class PosConcatenationFilter
extends ConcatenationFilter {
    private final Set<String> posTags;
    private final PartOfSpeechSupplier supplier;

    public PosConcatenationFilter(TokenStream input, Set<String> posTags, PartOfSpeechSupplier supplier) {
        super(input);
        this.posTags = posTags;
        this.supplier = supplier;
    }

    @Override
    protected boolean isTarget() {
        String pos = this.supplier.get();
        return pos != null && this.posTags.contains(pos);
    }

    @Override
    protected boolean isConcatenated() {
        String pos = this.supplier.get();
        return pos != null && this.posTags.contains(pos);
    }

    public static interface PartOfSpeechSupplier {
        public String get();
    }
}

