/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.en.AlphaNumWordFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class AlphaNumWordFilterFactory
extends AbstractTokenFilterFactory {
    private final int maxTokenLength;

    public AlphaNumWordFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.maxTokenLength = settings.getAsInt("max_token_length", Integer.valueOf(255));
    }

    public TokenStream create(TokenStream tokenStream) {
        AlphaNumWordFilter alphaNumWordFilter = new AlphaNumWordFilter(tokenStream);
        alphaNumWordFilter.setMaxTokenLength(this.maxTokenLength);
        return alphaNumWordFilter;
    }
}

