/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.ja.CharTypeFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class CharTypeFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean alphabetic;
    private final boolean digit;
    private final boolean letter;

    public CharTypeFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.alphabetic = settings.getAsBoolean("alphabetic", Boolean.valueOf(true));
        this.digit = settings.getAsBoolean("digit", Boolean.valueOf(true));
        this.letter = settings.getAsBoolean("letter", Boolean.valueOf(true));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new CharTypeFilter(tokenStream, this.alphabetic, this.digit, this.letter);
    }
}

