/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.codelibs.analysis.ja.NumberConcatenationFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class NumberConcatenationFilterFactory
extends AbstractTokenFilterFactory {
    private CharArraySet suffixWords;

    public NumberConcatenationFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        block15: {
            super(indexSettings, name, settings);
            String suffixWordsPath = settings.get("suffix_words_path");
            if (suffixWordsPath != null) {
                File suffixWordsFile = environment.configFile().resolve(suffixWordsPath).toFile();
                try (Reader reader = IOUtils.getDecodingReader((InputStream)new FileInputStream(suffixWordsFile), (Charset)StandardCharsets.UTF_8);){
                    this.suffixWords = WordlistLoader.getWordSet((Reader)reader);
                    break block15;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not load " + suffixWordsFile.getAbsolutePath(), e);
                }
            }
            this.suffixWords = new CharArraySet(0, false);
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new NumberConcatenationFilter(tokenStream, this.suffixWords);
    }
}

