/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.ja.PatternConcatenationFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class PatternConcatenationFilterFactory
extends AbstractTokenFilterFactory {
    private Pattern pattern1;
    private Pattern pattern2;

    public PatternConcatenationFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String pattern1Str = settings.get("pattern1");
        String pattern2Str = settings.get("pattern2", ".*");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("pattern1: {}, pattern2: {}", (Object)pattern1Str, (Object)pattern2Str);
        }
        if (pattern1Str != null) {
            this.pattern1 = Pattern.compile(pattern1Str);
            this.pattern2 = Pattern.compile(pattern2Str);
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new PatternConcatenationFilter(tokenStream, this.pattern1, this.pattern2);
    }
}

