/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import java.nio.file.Path;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.en.ReloadableKeywordMarkerFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class ReloadableKeywordMarkerFilterFactory
extends AbstractTokenFilterFactory {
    private final Path keywordPath;
    private final long reloadInterval;

    public ReloadableKeywordMarkerFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String path = settings.get("keywords_path");
        this.keywordPath = path != null ? environment.configFile().resolve(path) : null;
        this.reloadInterval = settings.getAsTime("reload_interval", TimeValue.timeValueMinutes((long)1L)).getMillis();
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.keywordPath == null) {
            return tokenStream;
        }
        return new ReloadableKeywordMarkerFilter(tokenStream, this.keywordPath, this.reloadInterval);
    }
}

