/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.EnumMap;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.util.AttributeSource;
import org.codelibs.elasticsearch.ja.kuromoji.index.analysis.KuromojiTokenizerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class ReloadableKuromojiTokenizerFactory
extends AbstractTokenizerFactory {
    private static final boolean VERBOSE = false;
    protected static final Reader ILLEGAL_STATE_READER = new Reader(){

        @Override
        public int read(char[] cbuf, int off, int len) {
            throw new IllegalStateException("TokenStream contract violation: reset()/close() call missing, reset() called multiple times, or subclass does not call super.reset(). Please see Javadocs of TokenStream class for more information about the correct consuming workflow.");
        }

        @Override
        public void close() {
        }
    };
    protected final Field inputPendingField;
    protected final Field userDictionaryField;
    protected final Field userFSTField;
    protected final Field userFSTReaderField;
    protected final Field dictionaryMapField;
    private final Environment env;
    private final Settings settings;
    private File reloadableFile = null;
    protected volatile long dictionaryTimestamp;
    private volatile long lastChecked;
    private long reloadInterval;
    private volatile UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final boolean discartPunctuation;

    public ReloadableKuromojiTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.env = env;
        this.settings = settings;
        this.mode = KuromojiTokenizerFactory.getMode(settings);
        this.userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.discartPunctuation = settings.getAsBoolean("discard_punctuation", Boolean.valueOf(true));
        this.inputPendingField = ReloadableKuromojiTokenizerFactory.getAccessibleField(Tokenizer.class, "inputPending");
        this.userDictionaryField = ReloadableKuromojiTokenizerFactory.getAccessibleField(JapaneseTokenizer.class, "userDictionary");
        this.userFSTField = ReloadableKuromojiTokenizerFactory.getAccessibleField(JapaneseTokenizer.class, "userFST");
        this.userFSTReaderField = ReloadableKuromojiTokenizerFactory.getAccessibleField(JapaneseTokenizer.class, "userFSTReader");
        this.dictionaryMapField = ReloadableKuromojiTokenizerFactory.getAccessibleField(JapaneseTokenizer.class, "dictionaryMap");
        this.dictionaryTimestamp = System.currentTimeMillis();
        String monitoringFilePath = settings.get("user_dictionary");
        if (monitoringFilePath != null) {
            Path path = env.configFile().resolve(monitoringFilePath);
            try {
                File file = path.toFile();
                if (file.exists()) {
                    this.reloadableFile = file;
                    this.dictionaryTimestamp = this.reloadableFile.lastModified();
                    this.reloadInterval = settings.getAsTime("reload_interval", TimeValue.timeValueMinutes((long)1L)).getMillis();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access " + monitoringFilePath, e);
            }
        }
    }

    public Tokenizer create() {
        return new TokenizerWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDictionary() {
        if (this.reloadableFile != null && System.currentTimeMillis() - this.lastChecked > this.reloadInterval) {
            this.lastChecked = System.currentTimeMillis();
            long timestamp = this.reloadableFile.lastModified();
            if (timestamp != this.dictionaryTimestamp) {
                File file = this.reloadableFile;
                synchronized (file) {
                    if (timestamp != this.dictionaryTimestamp) {
                        this.userDictionary = KuromojiTokenizerFactory.getUserDictionary(this.env, this.settings);
                        this.dictionaryTimestamp = timestamp;
                    }
                }
            }
        }
    }

    private static Field getAccessibleField(Class<?> clazz, String name) {
        return AccessController.doPrivileged(() -> {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to load fields.", e);
            }
        });
    }

    public final class TokenizerWrapper
    extends Tokenizer {
        private final JapaneseTokenizer tokenizer;
        private long tokenizerTimestamp;

        TokenizerWrapper() {
            this.tokenizerTimestamp = ReloadableKuromojiTokenizerFactory.this.dictionaryTimestamp;
            this.tokenizer = new JapaneseTokenizer(ReloadableKuromojiTokenizerFactory.this.userDictionary, ReloadableKuromojiTokenizerFactory.this.discartPunctuation, ReloadableKuromojiTokenizerFactory.this.mode);
            try {
                Field attributesField = ReloadableKuromojiTokenizerFactory.getAccessibleField(AttributeSource.class, "attributes");
                Object attributesObj = attributesField.get(this.tokenizer);
                attributesField.set((Object)this, attributesObj);
                Field attributeImplsField = ReloadableKuromojiTokenizerFactory.getAccessibleField(AttributeSource.class, "attributeImpls");
                Object attributeImplsObj = attributeImplsField.get(this.tokenizer);
                attributeImplsField.set((Object)this, attributeImplsObj);
                Field currentStateField = ReloadableKuromojiTokenizerFactory.getAccessibleField(AttributeSource.class, "currentState");
                Object currentStateObj = currentStateField.get(this.tokenizer);
                currentStateField.set((Object)this, currentStateObj);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to update the tokenizer.", e);
            }
        }

        public void close() throws IOException {
            this.tokenizer.close();
        }

        public void reset() throws IOException {
            Reader inputPending;
            ReloadableKuromojiTokenizerFactory.this.updateUserDictionary();
            if (ReloadableKuromojiTokenizerFactory.this.dictionaryTimestamp > this.tokenizerTimestamp && ReloadableKuromojiTokenizerFactory.this.userDictionary != null) {
                try {
                    this.tokenizerTimestamp = ReloadableKuromojiTokenizerFactory.this.dictionaryTimestamp;
                    ReloadableKuromojiTokenizerFactory.this.userDictionaryField.set(this.tokenizer, ReloadableKuromojiTokenizerFactory.this.userDictionary);
                    TokenInfoFST userFst = ReloadableKuromojiTokenizerFactory.this.userDictionary.getFST();
                    ReloadableKuromojiTokenizerFactory.this.userFSTField.set(this.tokenizer, userFst);
                    ReloadableKuromojiTokenizerFactory.this.userFSTReaderField.set(this.tokenizer, userFst.getBytesReader());
                    EnumMap dictionaryMap = (EnumMap)ReloadableKuromojiTokenizerFactory.this.dictionaryMapField.get(this.tokenizer);
                    dictionaryMap.put(JapaneseTokenizer.Type.USER, ReloadableKuromojiTokenizerFactory.this.userDictionary);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to update the tokenizer.", e);
                }
            }
            if ((inputPending = this.getInputPending()) != ILLEGAL_STATE_READER) {
                this.tokenizer.setReader(inputPending);
            }
            this.tokenizer.reset();
        }

        public boolean incrementToken() throws IOException {
            return this.tokenizer.incrementToken();
        }

        public void end() throws IOException {
            this.tokenizer.end();
        }

        public int hashCode() {
            return this.tokenizer.hashCode();
        }

        public boolean equals(Object obj) {
            return this.tokenizer.equals(obj);
        }

        public String toString() {
            return this.tokenizer.toString();
        }

        private Reader getInputPending() {
            try {
                return (Reader)ReloadableKuromojiTokenizerFactory.this.inputPendingField.get((Object)this);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

