/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import java.nio.file.Path;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.en.ReloadableStopFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class ReloadableStopFilterFactory
extends AbstractTokenFilterFactory {
    private final Path stopwordPath;
    private final long reloadInterval;
    private final boolean ignoreCase;

    public ReloadableStopFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        String path = settings.get("stopwords_path");
        this.stopwordPath = path != null ? environment.configFile().resolve(path) : null;
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        this.reloadInterval = settings.getAsTime("reload_interval", TimeValue.timeValueMinutes((long)1L)).getMillis();
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.stopwordPath == null) {
            return tokenStream;
        }
        return new ReloadableStopFilter(tokenStream, this.stopwordPath, this.ignoreCase, this.reloadInterval);
    }
}

