/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.analysis;

import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.codelibs.analysis.ja.StopTokenPrefixFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class StopTokenPrefixFilterFactory
extends AbstractTokenFilterFactory {
    private final String[] stopwords;
    private final boolean ignoreCase;

    public StopTokenPrefixFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        List wordList = Analysis.getWordList((Environment)environment, (Settings)settings, (String)"stopwords");
        this.stopwords = wordList != null ? wordList.toArray(new String[wordList.size()]) : new String[0];
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.FALSE);
        if (this.ignoreCase) {
            for (int i = 0; i < this.stopwords.length; ++i) {
                this.stopwords[i] = this.stopwords[i].toLowerCase(Locale.ROOT);
            }
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new StopTokenPrefixFilter(tokenStream, this.stopwords, this.ignoreCase);
    }
}

