/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.ja.kuromoji.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.codelibs.elasticsearch.ja.kuromoji.index.analysis.KuromojiTokenizerFactory;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;

public class KuromojiAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JapaneseAnalyzer> {
    private final JapaneseAnalyzer analyzer;

    public KuromojiAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Version)indexSettings.getIndexVersionCreated(), (Settings)settings, (CharArraySet)JapaneseAnalyzer.getDefaultStopSet());
        JapaneseTokenizer.Mode mode = KuromojiTokenizerFactory.getMode(settings);
        UserDictionary userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.analyzer = new JapaneseAnalyzer(userDictionary, mode, CharArraySet.copy((Set)stopWords), JapaneseAnalyzer.getDefaultStopTags());
    }

    public JapaneseAnalyzer get() {
        return this.analyzer;
    }
}

