/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.FST;
import org.codelibs.elasticsearch.synonym.analysis.SynonymLoader;

public final class NGramSynonymTokenizer
extends Tokenizer {
    public static final int DEFAULT_N_SIZE = 2;
    public static final String DEFAULT_DELIMITERS = " \u3000\t\n\r";
    static final int BUFFER_SIZE = 4096;
    private final int n;
    private final String delimiters;
    private final boolean expand;
    private final boolean ignoreCase;
    private final SynonymLoader synonymLoader;
    private long lastModified;
    private SynonymMap synonymMap = null;
    private FST.Arc<BytesRef> scratchArc;
    private FST<BytesRef> fst;
    private FST.BytesReader fstReader;
    private BytesRef scratchBytes = new BytesRef();
    private CharsRef scratchChars = new CharsRef();
    private int longestMatchEndOffset;
    private int ch;
    private char[] readBuffer;
    private int readBufferIndex;
    private int readBufferLen;
    StringBuilder block;
    int blkStart;
    int nextBlkStart;
    private int finalOffset;
    private final PriorityQueue<MyToken> queue;
    private MyToken prevToken;
    private final List<MyToken> synonyms;
    private CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private OffsetAttribute offsetAttr = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private PositionIncrementAttribute posIncAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    protected NGramSynonymTokenizer(int n, String delimiters, boolean expand, boolean ignoreCase, SynonymLoader synonymLoader) {
        this.n = n;
        this.delimiters = delimiters;
        this.expand = expand;
        this.ignoreCase = ignoreCase;
        if (synonymLoader != null) {
            if (synonymLoader.isReloadable()) {
                this.synonymLoader = synonymLoader;
                this.lastModified = synonymLoader.getLastModified();
            } else {
                this.synonymLoader = null;
                this.lastModified = System.currentTimeMillis();
            }
            this.synonymMap = synonymLoader.getSynonymMap();
            if (this.synonymMap != null && this.synonymMap.fst == null) {
                this.synonymMap = null;
            }
        } else {
            this.synonymLoader = null;
        }
        if (this.synonymMap != null) {
            this.fst = this.synonymMap.fst;
            this.fstReader = this.fst.getBytesReader();
            this.scratchArc = new FST.Arc();
        }
        this.ch = 0;
        this.readBuffer = new char[4096];
        this.readBufferIndex = 4096;
        this.readBufferLen = 0;
        this.block = new StringBuilder();
        this.nextBlkStart = 0;
        this.queue = new PriorityQueue<MyToken>(100, new MyTokensComparator());
        this.synonyms = new ArrayList<MyToken>();
    }

    public boolean incrementToken() throws IOException {
        MyToken nextToken;
        while ((nextToken = NGramSynonymTokenizer.getNextUniqueToken(this.queue, this.prevToken)) == null) {
            this.getNextBlock();
            if (this.block.length() == 0) {
                return false;
            }
            this.consultDictionary();
            this.tokenizeWholeBlock();
        }
        this.prevToken = nextToken;
        this.clearAttributes();
        this.termAttr.append(nextToken.word);
        this.finalOffset = this.correctOffset(this.blkStart + nextToken.endOffset);
        this.offsetAttr.setOffset(this.correctOffset(this.blkStart + nextToken.startOffset), this.finalOffset);
        this.posIncAttr.setPositionIncrement(nextToken.posInc);
        return true;
    }

    static MyToken getNextUniqueToken(PriorityQueue<MyToken> que, MyToken prev) {
        MyToken token;
        do {
            if ((token = que.poll()) != null) continue;
            return null;
        } while (prev != null && prev.identical(token));
        return token;
    }

    void consultDictionary() throws IOException {
        if (this.synonymMap == null) {
            return;
        }
        this.synonyms.clear();
        char[] key = this.block.toString().toCharArray();
        int start = 0;
        while (start < this.block.length()) {
            BytesRef matchOutput = this.getLongestMatchOutput(key, start);
            if (matchOutput == null) {
                ++start;
                continue;
            }
            this.synonyms.add(new MyToken(key, start, this.longestMatchEndOffset, 1, matchOutput.clone(), this.ignoreCase));
            start = this.longestMatchEndOffset;
        }
    }

    BytesRef getLongestMatchOutput(char[] src, int start) throws IOException {
        BytesRef pendingOutput = (BytesRef)this.fst.outputs.getNoOutput();
        this.fst.getFirstArc(this.scratchArc);
        assert (this.scratchArc.output == this.fst.outputs.getNoOutput());
        BytesRef matchOutput = null;
        int index = 0;
        while (start + index < src.length) {
            int codePoint = Character.codePointAt(src, start + index, src.length);
            if (this.fst.findTargetArc(this.ignoreCase ? Character.toLowerCase(codePoint) : codePoint, this.scratchArc, this.scratchArc, this.fstReader) == null) {
                return matchOutput;
            }
            pendingOutput = (BytesRef)this.fst.outputs.add((Object)pendingOutput, this.scratchArc.output);
            if (this.scratchArc.isFinal()) {
                matchOutput = (BytesRef)this.fst.outputs.add((Object)pendingOutput, this.scratchArc.nextFinalOutput);
                this.longestMatchEndOffset = start + index + Character.charCount(codePoint);
            }
            index += Character.charCount(codePoint);
        }
        return matchOutput;
    }

    void tokenizeWholeBlock() {
        this.queue.clear();
        int nextStart = 0;
        int end = this.block.length();
        boolean afterSynonymProduced = false;
        ByteArrayDataInput bytesReader = new ByteArrayDataInput();
        for (int idx = 0; idx < this.synonyms.size(); ++idx) {
            int limitOffset;
            MyToken synonym = this.synonyms.get(idx);
            this.tokenizePartialBlock(nextStart, synonym.startOffset, afterSynonymProduced);
            if (this.expand) {
                limitOffset = 0;
                if (idx > 0) {
                    limitOffset = this.synonyms.get((int)(idx - 1)).endOffset;
                }
                this.processPrevSynonym(synonym.startOffset, limitOffset);
            }
            this.queue.add(synonym);
            if (this.expand) {
                bytesReader.reset(synonym.output.bytes, synonym.output.offset, synonym.output.length);
                int code = bytesReader.readVInt();
                int count = code >>> 1;
                for (int i = 0; i < count; ++i) {
                    this.synonymMap.words.get(bytesReader.readVInt(), this.scratchBytes);
                    if (this.scratchChars.chars.length < this.scratchBytes.length) {
                        this.scratchChars.chars = new char[this.scratchBytes.length];
                    }
                    this.scratchChars.length = UnicodeUtil.UTF8toUTF16((BytesRef)this.scratchBytes, (char[])this.scratchChars.chars);
                    String word = this.scratchChars.toString();
                    int posInc = 0;
                    int seq = i + 1;
                    if (synonym.word.equals(word)) {
                        posInc = 1;
                        seq = 0;
                    }
                    this.queue.add(new MyToken(word, synonym.startOffset, synonym.endOffset, posInc, seq));
                }
            }
            if (this.expand) {
                limitOffset = this.block.length();
                if (idx < this.synonyms.size() - 1) {
                    limitOffset = this.synonyms.get((int)(idx + 1)).startOffset;
                }
                afterSynonymProduced = this.processAfterSynonym(synonym.endOffset, limitOffset);
            }
            nextStart = synonym.endOffset;
        }
        this.tokenizePartialBlock(nextStart, end, afterSynonymProduced);
    }

    void tokenizePartialBlock(int startOffset, int endOffset, boolean afterSynonymProduced) {
        int posInc;
        if (startOffset >= endOffset) {
            return;
        }
        int n = posInc = afterSynonymProduced ? 0 : 1;
        if (endOffset - startOffset < this.n) {
            this.queue.add(new MyToken(this.block.substring(startOffset, endOffset), startOffset, endOffset, posInc));
            return;
        }
        int i = startOffset;
        while (i + this.n <= endOffset) {
            this.queue.add(new MyToken(this.block.substring(i, i + this.n), i, i + this.n, posInc));
            posInc = 1;
            ++i;
        }
    }

    void processPrevSynonym(int endOffset, int limitOffset) {
        int startOffset = endOffset - 1;
        for (int len = 1; len < this.n && startOffset >= limitOffset; --startOffset, ++len) {
            this.queue.add(new MyToken(this.block.substring(startOffset, endOffset), startOffset, endOffset, 0));
        }
    }

    boolean processAfterSynonym(int startOffset, int limitOffset) {
        int qSize = this.queue.size();
        int endOffset = startOffset + 1;
        int posInc = 1;
        for (int len = 1; len < this.n && endOffset <= limitOffset; ++endOffset, ++len) {
            this.queue.add(new MyToken(this.block.substring(startOffset, endOffset), startOffset, endOffset, posInc));
            posInc = 0;
        }
        return this.queue.size() > qSize;
    }

    public void end() throws IOException {
        super.end();
        this.offsetAttr.setOffset(this.finalOffset, this.finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.block.setLength(0);
        this.prevToken = null;
        this.readBufferIndex = 4096;
        this.readBufferLen = 0;
        this.ch = 0;
        this.blkStart = 0;
        this.nextBlkStart = 0;
        if (this.synonymLoader != null && this.synonymLoader.isUpdate(this.lastModified)) {
            this.lastModified = this.synonymLoader.getLastModified();
            SynonymMap map = this.synonymLoader.getSynonymMap();
            if (map != null) {
                this.synonymMap = map;
                this.fst = this.synonymMap.fst;
                if (this.fst == null) {
                    throw new IllegalArgumentException("fst must be non-null");
                }
                this.fstReader = this.fst.getBytesReader();
                this.scratchArc = new FST.Arc();
                this.clearAttributes();
            }
        }
    }

    boolean getNextBlock() throws IOException {
        this.blkStart = this.nextBlkStart;
        this.block.setLength(0);
        this.prevToken = null;
        while (true) {
            if (this.ch != -1) {
                this.ch = this.readCharFromBuffer();
            }
            if (this.ch == -1) break;
            if (!this.isDelimiter(this.ch)) {
                this.block.append((char)this.ch);
                continue;
            }
            if (this.block.length() > 0) break;
            ++this.blkStart;
        }
        return this.block.length() != 0;
    }

    int readCharFromBuffer() throws IOException {
        if (this.readBufferIndex >= this.readBufferLen) {
            this.readBufferLen = this.input.read(this.readBuffer);
            if (this.readBufferLen == -1) {
                return -1;
            }
            this.readBufferIndex = 0;
        }
        char c = this.readBuffer[this.readBufferIndex++];
        ++this.nextBlkStart;
        return c;
    }

    boolean isDelimiter(int c) {
        return this.delimiters.indexOf(c) >= 0;
    }

    static class MyTokensComparator
    implements Comparator<MyToken> {
        MyTokensComparator() {
        }

        @Override
        public int compare(MyToken t1, MyToken t2) {
            if (t1.startOffset < t2.startOffset) {
                return -1;
            }
            if (t1.startOffset > t2.startOffset) {
                return 1;
            }
            if (t1.endOffset < t2.endOffset) {
                return -1;
            }
            if (t1.endOffset > t2.endOffset) {
                return 1;
            }
            if (t1.posInc > t2.posInc) {
                return -1;
            }
            if (t1.posInc < t2.posInc) {
                return 1;
            }
            if (t1.seq < t2.seq) {
                return -1;
            }
            if (t1.seq > t2.seq) {
                return 1;
            }
            return -1;
        }
    }

    static class MyToken {
        final String word;
        final int startOffset;
        final int endOffset;
        final int posInc;
        final int seq;
        final BytesRef output;

        public MyToken(char[] key, int startOffset, int endOffset, int posInc, BytesRef output, boolean ignoreCase) {
            this.word = ignoreCase ? new String(key, startOffset, endOffset - startOffset).toLowerCase() : new String(key, startOffset, endOffset - startOffset);
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.posInc = posInc;
            this.output = output;
            this.seq = 0;
        }

        public MyToken(String word, int startOffset, int endOffset, int posInc) {
            this(word, startOffset, endOffset, posInc, Integer.MAX_VALUE);
        }

        public MyToken(String word, int startOffset, int endOffset, int posInc, int seq) {
            this.word = word;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.posInc = posInc;
            this.output = null;
            this.seq = seq;
        }

        public boolean identical(MyToken o) {
            if (o.posInc != 0) {
                return false;
            }
            if (!this.word.equals(o.word)) {
                return false;
            }
            if (this.startOffset != o.startOffset) {
                return false;
            }
            return this.endOffset == o.endOffset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.word).append(',').append(this.startOffset).append(',').append(this.endOffset).append(',').append(this.posInc);
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof MyToken)) {
                return false;
            }
            MyToken o = (MyToken)other;
            if (!this.word.equals(o.word)) {
                return false;
            }
            if (this.startOffset != o.startOffset) {
                return false;
            }
            if (this.endOffset != o.endOffset) {
                return false;
            }
            return this.posInc == o.posInc;
        }

        public int hashCode() {
            return this.word.hashCode() + this.posInc << 30 + this.startOffset << 15 + this.endOffset;
        }
    }
}

