/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.codelibs.elasticsearch.synonym.analysis.NGramSynonymTokenizer;
import org.codelibs.elasticsearch.synonym.analysis.SynonymLoader;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public final class NGramSynonymTokenizerFactory
extends AbstractTokenizerFactory {
    private final boolean ignoreCase;
    private final int n;
    private final String delimiters;
    private final boolean expand;
    private SynonymLoader synonymLoader = null;

    @Inject
    public NGramSynonymTokenizerFactory(Index index, IndexSettingsService indexSettingsService, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(true));
        this.n = settings.getAsInt("n", Integer.valueOf(2));
        this.delimiters = settings.get("delimiters", " \u3000\t\n\r");
        this.expand = settings.getAsBoolean("expand", Boolean.valueOf(true));
        this.synonymLoader = new SynonymLoader(env, settings, this.expand, SynonymLoader.getAnalyzer(this.ignoreCase));
        if (this.synonymLoader.getSynonymMap() == null) {
            if (settings.getAsArray("synonyms", null) != null) {
                this.logger.warn("synonyms values are empty.", new Object[0]);
            } else if (settings.get("synonyms_path") != null) {
                this.logger.warn("synonyms_path[{}] is empty.", new Object[]{settings.get("synonyms_path")});
            } else {
                this.logger.debug("No synonym data.", new Object[0]);
            }
        }
    }

    public Tokenizer create() {
        return new NGramSynonymTokenizer(this.n, this.delimiters, this.expand, this.ignoreCase, this.synonymLoader);
    }
}

