/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym.analysis;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.codelibs.elasticsearch.synonym.analysis.SynonymFilter;
import org.codelibs.elasticsearch.synonym.analysis.SynonymLoader;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

@AnalysisSettingsRequired
public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean ignoreCase;
    private SynonymLoader synonymLoader = null;

    @Inject
    public SynonymTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, Environment env, IndicesAnalysisService indicesAnalysisService, Map<String, TokenizerFactoryFactory> tokenizerFactories, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        boolean expand = settings.getAsBoolean("expand", Boolean.valueOf(true));
        String tokenizerName = settings.get("tokenizer", "whitespace");
        TokenizerFactoryFactory tokenizerFactoryFactory = tokenizerFactories.get(tokenizerName);
        if (tokenizerFactoryFactory == null) {
            tokenizerFactoryFactory = indicesAnalysisService.tokenizerFactoryFactory(tokenizerName);
        }
        if (tokenizerFactoryFactory == null) {
            throw new IllegalArgumentException("failed to find tokenizer [" + tokenizerName + "] for synonym token filter");
        }
        final TokenizerFactory tokenizerFactory = tokenizerFactoryFactory.create(tokenizerName, Settings.builder().put(indexSettingsService.getSettings()).put(settings).build());
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                WhitespaceTokenizer tokenizer = tokenizerFactory == null ? new WhitespaceTokenizer() : tokenizerFactory.create();
                WhitespaceTokenizer stream = SynonymTokenFilterFactory.this.ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        this.synonymLoader = new SynonymLoader(env, settings, expand, analyzer);
        if (this.synonymLoader.getSynonymMap() == null) {
            if (settings.getAsArray("synonyms", null) != null) {
                this.logger.warn("synonyms values are empty.", new Object[0]);
            } else if (settings.get("synonyms_path") != null) {
                this.logger.warn("synonyms_path[{}] is empty.", new Object[]{settings.get("synonyms_path")});
            } else {
                throw new IllegalArgumentException("synonym requires either `synonyms` or `synonyms_path` to be configured");
            }
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return this.synonymLoader == null ? tokenStream : new SynonymFilter(tokenStream, this.synonymLoader, this.ignoreCase);
    }
}

