/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.codelibs.elasticsearch.synonym.analysis.NGramSynonymTokenizer;
import org.codelibs.elasticsearch.synonym.analysis.SynonymLoader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public final class NGramSynonymTokenizerFactory
extends AbstractTokenizerFactory {
    private final boolean ignoreCase;
    private final int n;
    private final String delimiters;
    private final boolean expand;
    private SynonymLoader synonymLoader = null;

    public NGramSynonymTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(true));
        this.n = settings.getAsInt("n", Integer.valueOf(2));
        this.delimiters = settings.get("delimiters", " \u3000\t\n\r");
        this.expand = settings.getAsBoolean("expand", Boolean.valueOf(true));
        this.synonymLoader = new SynonymLoader(env, settings, this.expand, SynonymLoader.getAnalyzer(this.ignoreCase));
        if (this.synonymLoader.getSynonymMap() == null) {
            if (settings.getAsArray("synonyms", null) != null) {
                this.logger.warn("synonyms values are empty.");
            } else if (settings.get("synonyms_path") != null) {
                this.logger.warn("synonyms_path[{}] is empty.", (Object)settings.get("synonyms_path"));
            } else {
                this.logger.debug("No synonym data.");
            }
        }
    }

    public Tokenizer create() {
        return new NGramSynonymTokenizer(this.n, this.delimiters, this.expand, this.ignoreCase, this.synonymLoader);
    }
}

