/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.synonym.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.analysis.Analysis;

public class SynonymLoader {
    private File reloadableFile = null;
    private Analyzer analyzer;
    private Settings settings;
    private boolean expand;
    private long reloadInterval = 0L;
    private Environment env;
    private volatile long lastModified;
    private volatile long lastChecked;
    private volatile SynonymMap synonymMap;

    public SynonymLoader(Environment env, Settings settings, boolean expand, Analyzer analyzer) {
        this.env = env;
        this.settings = settings;
        this.expand = expand;
        this.analyzer = analyzer;
        this.createSynonymMap(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdate(long time) {
        if (System.currentTimeMillis() - this.lastChecked > this.reloadInterval) {
            this.lastChecked = System.currentTimeMillis();
            long timestamp = this.reloadableFile.lastModified();
            if (timestamp != time) {
                File file = this.reloadableFile;
                synchronized (file) {
                    if (timestamp != this.lastModified) {
                        this.createSynonymMap(true);
                        return true;
                    }
                }
            }
        }
        return this.lastModified != time;
    }

    public SynonymMap getSynonymMap() {
        return this.synonymMap;
    }

    protected void createSynonymMap(boolean reload) {
        try (Reader rulesReader = this.getReader(reload);){
            if (rulesReader instanceof FastStringReader && ((FastStringReader)rulesReader).length() == 0) {
                this.synonymMap = null;
                return;
            }
            WordnetSynonymParser parser = null;
            if ("wordnet".equalsIgnoreCase(this.settings.get("format"))) {
                parser = new WordnetSynonymParser(true, this.expand, this.analyzer);
                parser.parse(rulesReader);
            } else {
                parser = new SolrSynonymParser(true, this.expand, this.analyzer);
                ((SolrSynonymParser)parser).parse(rulesReader);
            }
            SynonymMap localSynonymMap = parser.build();
            if (localSynonymMap.fst == null) {
                this.synonymMap = null;
                return;
            }
            this.synonymMap = localSynonymMap;
            this.lastModified = this.reloadableFile != null ? this.reloadableFile.lastModified() : System.currentTimeMillis();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to build synonyms", e);
        }
    }

    private Reader getReader(boolean reload) throws IOException {
        if (reload) {
            if (this.reloadableFile == null) {
                throw new IllegalArgumentException("reloadableFile is null.");
            }
            return new InputStreamReader((InputStream)new FileInputStream(this.reloadableFile), StandardCharsets.UTF_8);
        }
        Object reader = null;
        if (this.settings.getAsArray("synonyms", null) != null) {
            List rules = Analysis.getWordList((Environment)this.env, (Settings)this.settings, (String)"synonyms");
            StringBuilder sb = new StringBuilder();
            for (String line : rules) {
                sb.append(line).append(System.getProperty("line.separator"));
            }
            reader = new FastStringReader(sb.toString());
        } else if (this.settings.get("synonyms_path") != null) {
            if (this.settings.getAsBoolean("dynamic_reload", Boolean.valueOf(false)).booleanValue()) {
                String filePath = this.settings.get("synonyms_path", null);
                if (filePath == null) {
                    throw new IllegalArgumentException("synonyms_path is not found.");
                }
                Path path = this.env.configFile().resolve(filePath);
                try {
                    File file = path.toFile();
                    if (file.exists()) {
                        this.reloadableFile = file;
                    }
                    reader = FileSystemUtils.newBufferedReader((URL)path.toUri().toURL(), (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to read " + filePath, e);
                }
                this.reloadInterval = this.settings.getAsTime("reload_interval", TimeValue.timeValueMinutes((long)1L)).getMillis();
            } else {
                reader = Analysis.getReaderFromFile((Environment)this.env, (Settings)this.settings, (String)"synonyms_path");
            }
        } else {
            reader = new FastStringReader("");
        }
        return reader;
    }

    public boolean isReloadable() {
        return this.reloadableFile != null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected static Analyzer getAnalyzer(final boolean ignoreCase) {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                KeywordTokenizer stream = ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
    }
}

