/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.filter;

import java.util.concurrent.atomic.AtomicBoolean;
import org.codelibs.elasticsearch.auth.security.LoginConstraint;
import org.codelibs.elasticsearch.auth.service.AuthService;
import org.codelibs.elasticsearch.auth.util.ResponseUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class ContentFilter
extends RestFilter {
    private static final ESLogger logger = Loggers.getLogger(ContentFilter.class);
    private volatile LoginConstraint[] constraints = null;
    private AuthService authService;
    private AtomicBoolean initializing = new AtomicBoolean(false);

    public ContentFilter(AuthService authService) {
        this.authService = authService;
    }

    public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) {
        if (this.constraints == null) {
            this.init(request, channel, filterChain);
        } else {
            this.processNext(request, channel, filterChain);
        }
    }

    protected void init(final RestRequest request, final RestChannel channel, final RestFilterChain filterChain) {
        if (logger.isDebugEnabled()) {
            logger.debug("initializing: {0}", new Object[]{this.initializing});
        }
        if (!this.initializing.getAndSet(true)) {
            this.authService.init(new ActionListener<Void>(){

                public void onResponse(Void response) {
                    ContentFilter.this.initializing.set(false);
                    if (ContentFilter.this.constraints == null) {
                        ContentFilter.this.sendServiceUnavailable(request, channel);
                    } else {
                        ContentFilter.this.processNext(request, channel, filterChain);
                    }
                }

                public void onFailure(Throwable e) {
                    ContentFilter.this.initializing.set(false);
                    logger.warn("Failed to reload AuthService.", e, new Object[0]);
                    ContentFilter.this.sendServiceUnavailable(request, channel);
                }
            });
        } else {
            this.sendServiceUnavailable(request, channel);
        }
    }

    protected void processNext(final RestRequest request, final RestChannel channel, final RestFilterChain filterChain) {
        String rawPath = request.rawPath();
        for (LoginConstraint constraint : this.constraints) {
            if (!constraint.match(rawPath)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(rawPath + " is filtered.", new Object[0]);
            }
            final String token = this.authService.getToken(request);
            this.authService.authenticate(token, constraint.getRoles(request.method()), new ActionListener<Boolean>(){

                public void onResponse(Boolean isAuthenticated) {
                    if (isAuthenticated.booleanValue()) {
                        filterChain.continueProcessing(request, channel);
                    } else {
                        ResponseUtil.send(request, channel, RestStatus.FORBIDDEN, "message", "Forbidden. Not authorized.");
                    }
                }

                public void onFailure(Throwable e) {
                    logger.error("Authentication failed: token: " + token, e, new Object[0]);
                    ResponseUtil.send(request, channel, RestStatus.FORBIDDEN, "message", "Forbidden. Authentication failed.");
                }
            });
            return;
        }
        filterChain.continueProcessing(request, channel);
    }

    protected void sendServiceUnavailable(RestRequest request, RestChannel channel) {
        ResponseUtil.send(request, channel, RestStatus.SERVICE_UNAVAILABLE, "message", "A service is not available.");
    }

    public void setLoginConstraints(LoginConstraint[] constraints) {
        this.constraints = constraints;
    }
}

