/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.filter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.codelibs.elasticsearch.auth.security.Authenticator;
import org.codelibs.elasticsearch.auth.service.AuthService;
import org.codelibs.elasticsearch.auth.util.ResponseUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class LoginFilter
extends RestFilter {
    private static final ESLogger logger = Loggers.getLogger(LoginFilter.class);
    private RestRequest.Method[] methods = new RestRequest.Method[]{RestRequest.Method.POST, RestRequest.Method.PUT};
    private String loginPath = "/login";
    private Map<String, Authenticator> authenticatorMap;
    private AuthService authService;

    public LoginFilter(AuthService authService, Map<String, Authenticator> authenticatorMap) {
        this.authService = authService;
        this.authenticatorMap = authenticatorMap;
    }

    public void process(final RestRequest request, final RestChannel channel, RestFilterChain filterChain) {
        String rawPath = request.rawPath();
        if (rawPath.equals(this.loginPath)) {
            for (RestRequest.Method method : this.methods) {
                if (method != request.method()) continue;
                final ConcurrentHashMap roleMap = new ConcurrentHashMap();
                Map<String, Authenticator> authMap = this.authenticatorMap;
                final CountDownLatch latch = new CountDownLatch(authMap.size());
                for (final Map.Entry<String, Authenticator> entry : authMap.entrySet()) {
                    entry.getValue().login(request, new ActionListener<String[]>(){

                        public void onResponse(String[] roles) {
                            if (roles != null) {
                                for (String role : roles) {
                                    roleMap.put(role, entry.getKey());
                                }
                            }
                            latch.countDown();
                        }

                        public void onFailure(Throwable e) {
                            logger.warn("Failed to authenticate: " + (String)entry.getKey() + "/" + entry.getValue(), e, new Object[0]);
                            latch.countDown();
                        }
                    });
                }
                try {
                    latch.await();
                    this.authService.createToken(roleMap.keySet(), new ActionListener<String>(){

                        public void onResponse(String token) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Token " + token + " is generated.", new Object[0]);
                            }
                            ResponseUtil.send(request, channel, RestStatus.OK, "token", token);
                        }

                        public void onFailure(Throwable e) {
                            ResponseUtil.send(request, channel, RestStatus.BAD_REQUEST, "message", "Invalid username or password.");
                        }
                    });
                }
                catch (Exception e) {
                    logger.error("Login failed.", (Throwable)e, new Object[0]);
                    ResponseUtil.send(request, channel, RestStatus.INTERNAL_SERVER_ERROR, "message", "Login failed.");
                }
                return;
            }
            ResponseUtil.send(request, channel, RestStatus.BAD_REQUEST, "message", "Unsupported HTTP method for the login process.");
            return;
        }
        filterChain.continueProcessing(request, channel);
    }

    public void setLoginPath(String loginPath) {
        this.loginPath = loginPath;
    }

    public void setHttpMethods(RestRequest.Method[] method) {
        this.methods = method;
    }
}

