/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.filter;

import org.codelibs.elasticsearch.auth.AuthException;
import org.codelibs.elasticsearch.auth.service.AuthService;
import org.codelibs.elasticsearch.auth.util.ResponseUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class LogoutFilter
extends RestFilter {
    private static final ESLogger logger = Loggers.getLogger(LogoutFilter.class);
    private RestRequest.Method[] methods = new RestRequest.Method[]{RestRequest.Method.POST, RestRequest.Method.DELETE};
    private String logoutPath = "/logout";
    private AuthService authService;

    public LogoutFilter(AuthService authService) {
        this.authService = authService;
    }

    public void process(final RestRequest request, final RestChannel channel, RestFilterChain filterChain) {
        String rawPath = request.rawPath();
        if (rawPath.equals(this.logoutPath)) {
            for (RestRequest.Method method : this.methods) {
                if (method != request.method()) continue;
                String token = this.authService.getToken(request);
                if (token != null) {
                    this.authService.deleteToken(token, new ActionListener<Void>(){

                        public void onResponse(Void response) {
                            ResponseUtil.send(request, channel, RestStatus.OK, new String[0]);
                        }

                        public void onFailure(Throwable e) {
                            logger.error("Failed to delete the token.", e, new Object[0]);
                            if (e instanceof AuthException) {
                                ResponseUtil.send(request, channel, (AuthException)e);
                            } else {
                                ResponseUtil.send(request, channel, RestStatus.INTERNAL_SERVER_ERROR, "message", "Failed to delete the token.");
                            }
                        }
                    });
                } else {
                    ResponseUtil.send(request, channel, RestStatus.BAD_REQUEST, "message", "Invalid token.");
                }
                return;
            }
            ResponseUtil.send(request, channel, RestStatus.BAD_REQUEST, "message", "Unsupported HTTP method for the logout process.");
            return;
        }
        filterChain.continueProcessing(request, channel);
    }

    public void setHttpMethods(RestRequest.Method[] method) {
        this.methods = method;
    }

    public void setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
    }
}

