/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.rest;

import java.util.Map;
import org.codelibs.elasticsearch.auth.AuthException;
import org.codelibs.elasticsearch.auth.service.AuthService;
import org.codelibs.elasticsearch.auth.util.MapUtil;
import org.codelibs.elasticsearch.auth.util.ResponseUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class AccountRestAction
extends BaseRestHandler {
    private AuthService authService;

    @Inject
    public AccountRestAction(Settings settings, Client client, RestController restController, AuthService authService) {
        super(settings, restController, client);
        this.authService = authService;
        restController.registerHandler(RestRequest.Method.POST, "/_auth/account", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.PUT, "/_auth/account", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.DELETE, "/_auth/account", (RestHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(RestRequest request, RestChannel channel, Client client) {
        BytesReference content = request.content();
        XContentType xContentType = XContentFactory.xContentType((BytesReference)content);
        XContentParser parser = null;
        String authenticator = null;
        String username = null;
        String password = null;
        String[] roles = null;
        try {
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(content);
            XContentParser.Token t = parser.nextToken();
            if (t != null) {
                Map contentMap = parser.map();
                authenticator = MapUtil.getAsString(contentMap, "authenticator", null);
                username = MapUtil.getAsString(contentMap, "username", null);
                password = MapUtil.getAsString(contentMap, "password", null);
                roles = MapUtil.getAsArray(contentMap, "roles", new String[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not parse the content.", (Throwable)e, new Object[0]);
            ResponseUtil.send(request, channel, RestStatus.BAD_REQUEST, "message", "Could not parse the content.");
            return;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        this.processRequest(request, channel, authenticator, username, password, roles);
    }

    private void processRequest(final RestRequest request, final RestChannel channel, String authenticator, final String username, String password, String[] roles) {
        switch (request.method()) {
            case PUT: {
                this.authService.createUser(authenticator, username, password, roles, new ActionListener<Void>(){

                    public void onResponse(Void response) {
                        ResponseUtil.send(request, channel, RestStatus.OK, new String[0]);
                    }

                    public void onFailure(Throwable e) {
                        AccountRestAction.this.logger.error("Failed to create " + username, e, new Object[0]);
                        if (e instanceof AuthException) {
                            ResponseUtil.send(request, channel, (AuthException)e);
                        } else {
                            ResponseUtil.send(request, channel, RestStatus.INTERNAL_SERVER_ERROR, "message", "Could not create " + username);
                        }
                    }
                });
                break;
            }
            case POST: {
                this.authService.updateUser(authenticator, username, password, roles, new ActionListener<Void>(){

                    public void onResponse(Void response) {
                        ResponseUtil.send(request, channel, RestStatus.OK, new String[0]);
                    }

                    public void onFailure(Throwable e) {
                        AccountRestAction.this.logger.error("Failed to update " + username, e, new Object[0]);
                        if (e instanceof AuthException) {
                            ResponseUtil.send(request, channel, (AuthException)e);
                        } else {
                            ResponseUtil.send(request, channel, RestStatus.INTERNAL_SERVER_ERROR, "message", "Could not update " + username);
                        }
                    }
                });
                break;
            }
            case DELETE: {
                this.authService.deleteUser(authenticator, username, new ActionListener<Void>(){

                    public void onResponse(Void response) {
                        ResponseUtil.send(request, channel, RestStatus.OK, new String[0]);
                    }

                    public void onFailure(Throwable e) {
                        AccountRestAction.this.logger.error("Failed to delete " + username, e, new Object[0]);
                        if (e instanceof AuthException) {
                            ResponseUtil.send(request, channel, (AuthException)e);
                        } else {
                            ResponseUtil.send(request, channel, RestStatus.INTERNAL_SERVER_ERROR, "message", "Could not delete " + username);
                        }
                    }
                });
                break;
            }
            default: {
                ResponseUtil.send(request, channel, RestStatus.BAD_REQUEST, "message", "Invalid method: " + request.method().name());
            }
        }
    }
}

