/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.rest;

import org.codelibs.elasticsearch.auth.service.AuthService;
import org.codelibs.elasticsearch.auth.util.ResponseUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class ReloadRestAction
extends BaseRestHandler {
    private AuthService authService;

    @Inject
    public ReloadRestAction(Settings settings, Client client, RestController restController, AuthService authService) {
        super(settings, restController, client);
        this.authService = authService;
        restController.registerHandler(RestRequest.Method.POST, "/_auth/reload", (RestHandler)this);
    }

    protected void handleRequest(final RestRequest request, final RestChannel channel, Client client) {
        this.authService.reload(new ActionListener<Void>(){

            public void onResponse(Void response) {
                ResponseUtil.send(request, channel, RestStatus.OK, new String[0]);
            }

            public void onFailure(Throwable e) {
                ResponseUtil.send(request, channel, RestStatus.INTERNAL_SERVER_ERROR, "message", "Failed to reload AuthService.");
            }
        });
    }
}

