/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.security;

import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.codelibs.elasticsearch.auth.AuthException;
import org.codelibs.elasticsearch.auth.security.Authenticator;
import org.codelibs.elasticsearch.auth.service.AuthService;
import org.codelibs.elasticsearch.auth.util.MapUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class IndexAuthenticator
extends AbstractLifecycleComponent<IndexAuthenticator>
implements Authenticator {
    private static final ESLogger logger = Loggers.getLogger(IndexAuthenticator.class);
    protected Client client;
    protected AuthService authService;
    protected String authIndex;
    protected String userType;
    protected String usernameKey;
    protected String passwordKey;

    @Inject
    public IndexAuthenticator(Settings settings, Client client, AuthService authService) {
        super(settings);
        this.client = client;
        this.authService = authService;
        this.authIndex = settings.get("auth.authenticator.index.index", "auth");
        this.userType = settings.get("auth.authenticator.index.type", "user");
        this.usernameKey = settings.get("auth.authenticator.index.username", "username");
        this.passwordKey = settings.get("auth.authenticator.index.password", "password");
    }

    protected void doStart() throws ElasticsearchException {
        logger.info("Registering IndexAuthenticator.", new Object[0]);
        this.authService.registerAuthenticator("index", this);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void login(RestRequest request, ActionListener<String[]> listener) {
        String username = request.param(this.usernameKey);
        String password = request.param(this.passwordKey);
        BytesReference content = request.content();
        XContentType xContentType = XContentFactory.xContentType((BytesReference)content);
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)xContentType).createParser(content);
            XContentParser.Token t = parser.nextToken();
            if (t != null) {
                Map contentMap = parser.map();
                username = MapUtil.getAsString(contentMap, this.usernameKey, username);
                password = MapUtil.getAsString(contentMap, this.passwordKey, password);
            }
        }
        if (username == null) {
            listener.onResponse((Object)new String[0]);
            return;
        }
        this.processLogin(username, password, listener);
    }

    private void processLogin(String username, final String password, final ActionListener<String[]> listener) {
        this.client.prepareGet(this.authIndex, this.userType, this.getUserId(username)).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                String hash;
                Map sourceMap = response.getSource();
                if (sourceMap != null && (hash = (String)sourceMap.get("password")) != null && hash.equals(IndexAuthenticator.this.hashPassword(password))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(sourceMap.get("username") + " is logged in.", new Object[0]);
                    }
                    listener.onResponse((Object)MapUtil.getAsArray(sourceMap, "roles", new String[0]));
                    return;
                }
                listener.onResponse((Object)new String[0]);
            }

            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    public void createUser(final String username, String password, String[] roles, final ActionListener<Void> listener) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("username", username).field("password", this.hashPassword(password)).field("roles", roles).endObject();
            this.client.prepareIndex(this.authIndex, this.userType, this.getUserId(username)).setSource(builder).setRefresh(true).execute((ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    listener.onResponse(null);
                }

                public void onFailure(Throwable e) {
                    listener.onFailure((Throwable)new AuthException(RestStatus.INTERNAL_SERVER_ERROR, "Could not create " + username, e));
                }
            });
        }
        catch (Exception e) {
            listener.onFailure((Throwable)new AuthException(RestStatus.INTERNAL_SERVER_ERROR, "Could not create " + username, e));
        }
    }

    @Override
    public void updateUser(final String username, String password, String[] roles, final ActionListener<Void> listener) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("doc").startObject();
            if (password != null) {
                builder.field("password", this.hashPassword(password));
            }
            if (roles != null) {
                builder.field("roles", roles);
            }
            builder.endObject().endObject();
            final String userId = this.getUserId(username);
            this.client.prepareUpdate(this.authIndex, this.userType, userId).setSource(builder).setRefresh(true).execute((ActionListener)new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse response) {
                    if (!userId.equals(response.getId())) {
                        listener.onFailure((Throwable)new AuthException(RestStatus.BAD_REQUEST, "Could not update " + username));
                    } else {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Throwable e) {
                    listener.onFailure((Throwable)new AuthException(RestStatus.INTERNAL_SERVER_ERROR, "Could not update " + username, e));
                }
            });
        }
        catch (Exception e) {
            listener.onFailure((Throwable)new AuthException(RestStatus.INTERNAL_SERVER_ERROR, "Could not update " + username, e));
        }
    }

    @Override
    public void deleteUser(final String username, final ActionListener<Void> listener) {
        this.client.prepareDelete(this.authIndex, this.userType, this.getUserId(username)).setRefresh(true).execute((ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                if (response.isFound()) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Throwable)new AuthException(RestStatus.BAD_REQUEST, "Could not delete " + username));
                }
            }

            public void onFailure(Throwable e) {
                listener.onFailure((Throwable)new AuthException(RestStatus.INTERNAL_SERVER_ERROR, "Could not delete " + username, e));
            }
        });
    }

    protected String getUserId(String username) {
        return DigestUtils.sha512Hex((String)username);
    }

    protected String hashPassword(String password) {
        if (password == null) {
            return "";
        }
        return DigestUtils.sha512Hex((String)password);
    }
}

