/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.rest.RestRequest;

public class LoginConstraint {
    private String path;
    private Map<RestRequest.Method, Set<String>> methodMap = new HashMap<RestRequest.Method, Set<String>>();

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean match(String rawPath) {
        return rawPath.startsWith(this.path);
    }

    public void addCondition(String[] methods, String[] roles) {
        if (methods.length == 0) {
            for (RestRequest.Method method : RestRequest.Method.values()) {
                this.addRoles(method, roles);
            }
        } else {
            for (String name : methods) {
                RestRequest.Method method = this.getEsMethod(name);
                if (method == null) continue;
                this.addRoles(method, roles);
            }
        }
    }

    public String[] getRoles(RestRequest.Method method) {
        Set<String> roleSet = this.methodMap.get(method);
        if (roleSet != null) {
            return roleSet.toArray(new String[roleSet.size()]);
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoles(RestRequest.Method method, String[] roles) {
        Map<RestRequest.Method, Set<String>> map = this.methodMap;
        synchronized (map) {
            Set<String> roleSet = this.methodMap.get(method);
            if (roleSet == null) {
                roleSet = new HashSet<String>();
                this.methodMap.put(method, roleSet);
            }
            for (String role : roles) {
                roleSet.add(role);
            }
        }
    }

    private RestRequest.Method getEsMethod(String method) {
        if ("get".equalsIgnoreCase(method)) {
            return RestRequest.Method.GET;
        }
        if ("post".equalsIgnoreCase(method)) {
            return RestRequest.Method.POST;
        }
        if ("put".equalsIgnoreCase(method)) {
            return RestRequest.Method.PUT;
        }
        if ("delete".equalsIgnoreCase(method)) {
            return RestRequest.Method.DELETE;
        }
        if ("options".equalsIgnoreCase(method)) {
            return RestRequest.Method.OPTIONS;
        }
        if ("head".equalsIgnoreCase(method)) {
            return RestRequest.Method.HEAD;
        }
        return null;
    }
}

