/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.auth.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MapUtil {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    private MapUtil() {
    }

    public static String[] getAsArray(Map<String, Object> map, String key, String[] defaultValue) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            return new String[]{obj.toString()};
        }
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list.toArray(new String[list.size()]);
        }
        return defaultValue;
    }

    public static String getAsString(Map<String, Object> map, String key, String defaultValue) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof String[]) {
            return ((String[])obj)[0];
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return (String)list.get(0);
        }
        return defaultValue;
    }

    public static List<String> getAsList(Map<String, Object> map, String key, List<String> defaultValue) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(obj.toString());
            return list;
        }
        if (obj instanceof String[]) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(obj.toString());
            for (String value : (String[])obj) {
                list.add(value);
            }
            return list;
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        return defaultValue;
    }

    public static Date getAsDate(Map<String, Object> map, String key, Date defaultValue) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ROOT);
            try {
                return sdf.parse(obj.toString());
            }
            catch (ParseException e) {
                return defaultValue;
            }
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        return defaultValue;
    }
}

