/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank;

import java.util.ArrayList;
import java.util.Collection;
import org.codelibs.elasticsearch.dynarank.filter.SearchActionFilter;
import org.codelibs.elasticsearch.dynarank.module.DynamicRankerModule;
import org.codelibs.elasticsearch.dynarank.ranker.DynamicRanker;
import org.codelibs.elasticsearch.dynarank.script.DiversitySortScript;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.index.settings.IndexDynamicSettingsModule;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.script.ScriptModule;

public class DynamicRankingPlugin
extends AbstractPlugin {
    public String name() {
        return "DynamicRankingPlugin";
    }

    public String description() {
        return "This plugin re-orders top N documents in a search results.";
    }

    public void onModule(ScriptModule module) {
        module.registerScript("dynarank_diversity_sort", DiversitySortScript.Factory.class);
    }

    public void onModule(ActionModule module) {
        module.registerFilter(SearchActionFilter.class);
    }

    public void onModule(IndexDynamicSettingsModule module) {
        module.addDynamicSettings(new String[]{"index.dynarank.*"});
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        modules.add(DynamicRankerModule.class);
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        services.add(DynamicRanker.class);
        return services;
    }
}

