/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.filter;

import org.codelibs.elasticsearch.dynarank.ranker.DynamicRanker;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class SearchActionFilter
extends AbstractComponent
implements ActionFilter {
    private int order;
    private DynamicRanker dynamicRanker;
    private ThreadLocal<SearchType> currentSearchType = new ThreadLocal();

    @Inject
    public SearchActionFilter(Settings settings) {
        super(settings);
        this.order = settings.getAsInt("indices.dynarank.filter.order", Integer.valueOf(10));
    }

    public int order() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        if (!SearchAction.INSTANCE.name().equals(action)) {
            chain.proceed(action, request, (ActionListener)listener);
            return;
        }
        SearchRequest searchRequest = (SearchRequest)request;
        SearchType searchType = this.currentSearchType.get();
        if (searchType == null) {
            try {
                this.currentSearchType.set(searchRequest.searchType());
                chain.proceed(action, request, (ActionListener)listener);
            }
            finally {
                this.currentSearchType.remove();
            }
        } else {
            ActionListener<SearchResponse> wrappedListener = this.dynamicRanker.wrapActionListener(action, searchRequest, listener);
            chain.proceed(action, request, wrappedListener == null ? listener : wrappedListener);
        }
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, response, listener);
    }

    public void setDynamicRanker(DynamicRanker dynamicRanker) {
        this.dynamicRanker = dynamicRanker;
    }
}

