/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.script;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.codelibs.elasticsearch.dynarank.DynamicRankingException;
import org.codelibs.elasticsearch.dynarank.script.bucket.BucketFactory;
import org.codelibs.elasticsearch.dynarank.script.bucket.Buckets;
import org.codelibs.elasticsearch.dynarank.script.bucket.impl.StandardBucketFactory;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.AbstractExecutableScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.NativeScriptFactory;

public class DiversitySortScript
extends AbstractExecutableScript {
    private static ESLogger logger = ESLoggerFactory.getLogger((String)"script.dynarank.sort");
    public static final String SCRIPT_NAME = "dynarank_diversity_sort";
    private static final String STANDARD = "standard";
    private Map<String, Object> params;
    private Map<String, BucketFactory> bucketFactories;

    public DiversitySortScript(Map<String, Object> params, Map<String, BucketFactory> bucketFactories) {
        this.params = params;
        this.bucketFactories = bucketFactories;
    }

    public Object run() {
        BucketFactory bucketFactory;
        Object bucketFactoryName;
        if (logger.isDebugEnabled()) {
            logger.debug("Starting DiversitySortScript...", new Object[0]);
        }
        if ((bucketFactoryName = this.params.get("bucket_factory")) == null) {
            bucketFactoryName = STANDARD;
        }
        if ((bucketFactory = this.bucketFactories.get(bucketFactoryName)) == null) {
            throw new DynamicRankingException("bucket_factory is invalid: " + bucketFactoryName);
        }
        Buckets buckets = bucketFactory.createBucketList(this.params);
        return buckets.getHits();
    }

    public static class Factory
    implements NativeScriptFactory {
        private Map<String, BucketFactory> bucketFactories;

        @Inject
        public Factory(Settings settings) {
            Settings bucketSettings = settings.getByPrefix("script.dynarank.bucket.");
            this.bucketFactories = new HashMap<String, BucketFactory>();
            this.bucketFactories.put(DiversitySortScript.STANDARD, new StandardBucketFactory(settings));
            ImmutableMap bucketFactorySettings = bucketSettings.getAsMap();
            for (Map.Entry entry : bucketFactorySettings.entrySet()) {
                String name = (String)entry.getKey();
                try {
                    Class<?> clazz = Class.forName((String)entry.getValue());
                    Class[] types = new Class[]{Settings.class};
                    Constructor<?> constructor = clazz.getConstructor(types);
                    Object[] args = new Object[]{settings};
                    constructor.newInstance(args);
                }
                catch (Exception e) {
                    logger.warn("BucketFactory {} is not found.", (Throwable)e, new Object[]{name});
                }
            }
        }

        public ExecutableScript newScript(@Nullable Map<String, Object> params) {
            return new DiversitySortScript(params, this.bucketFactories);
        }
    }
}

