/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.script.bucket.impl;

import java.util.LinkedList;
import java.util.Queue;
import org.codelibs.elasticsearch.dynarank.minhash.MinHash;
import org.codelibs.elasticsearch.dynarank.script.bucket.Bucket;
import org.elasticsearch.search.internal.InternalSearchHit;

public class StandardBucket
implements Bucket {
    protected Queue<InternalSearchHit> queue = new LinkedList<InternalSearchHit>();
    protected Object hash;
    private float threshold;

    public StandardBucket(InternalSearchHit hit, Object hash, float threshold) {
        this.hash = hash;
        this.threshold = threshold;
        this.queue.add(hit);
    }

    @Override
    public void consume() {
        this.queue.poll();
    }

    @Override
    public InternalSearchHit get() {
        return this.queue.peek();
    }

    @Override
    public boolean contains(Object value) {
        if (this.hash == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        if (!this.hash.getClass().equals(value.getClass())) {
            return false;
        }
        if (value instanceof String) {
            return value.toString().equals(this.hash);
        }
        if (value instanceof Number) {
            return Math.abs(((Number)value).doubleValue() - ((Number)this.hash).doubleValue()) < (double)this.threshold;
        }
        if (value instanceof byte[]) {
            byte[] target = (byte[])value;
            return MinHash.compare((byte[])this.hash, target) >= this.threshold;
        }
        return false;
    }

    @Override
    public void add(Object ... args) {
        this.queue.add((InternalSearchHit)args[0]);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public String toString() {
        return "StandardBucket [queue=" + this.queue + ", hash=" + this.hash + ", threshold=" + this.threshold + "]";
    }
}

