/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.script.bucket.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.dynarank.DynamicRankingException;
import org.codelibs.elasticsearch.dynarank.script.bucket.Bucket;
import org.codelibs.elasticsearch.dynarank.script.bucket.BucketFactory;
import org.codelibs.elasticsearch.dynarank.script.bucket.Buckets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.internal.InternalSearchHit;

public class StandardBuckets
implements Buckets {
    private static ESLogger logger = ESLoggerFactory.getLogger((String)"script.dynarank.sort.bucket.standard");
    protected BucketFactory bucketFactory;
    protected Map<String, Object> params;

    public StandardBuckets(BucketFactory bucketFactory, Map<String, Object> params) {
        this.bucketFactory = bucketFactory;
        this.params = params;
    }

    @Override
    public InternalSearchHit[] getHits() {
        InternalSearchHit[] searchHits = (InternalSearchHit[])this.params.get("searchHits");
        int length = searchHits.length;
        Object[] diversityFields = (String[])this.params.get("diversity_fields");
        if (diversityFields == null) {
            throw new DynamicRankingException("diversity_fields is null.");
        }
        Object[] thresholds = (String[])this.params.get("diversity_thresholds");
        if (thresholds == null) {
            throw new DynamicRankingException("diversity_thresholds is null.");
        }
        float[] diversityThresholds = this.parseFloats((String[])thresholds);
        if (logger.isDebugEnabled()) {
            logger.debug("diversity_fields: {}, : diversity_thresholds{}", new Object[]{Arrays.toString(diversityFields), Arrays.toString(thresholds)});
        }
        for (int i = diversityFields.length - 1; i >= 0; --i) {
            Object diversityField = diversityFields[i];
            float diversityThreshold = diversityThresholds[i];
            ArrayList<Bucket> bucketList = new ArrayList<Bucket>();
            for (int j = 0; j < length; ++j) {
                boolean insert = false;
                InternalSearchHit hit = searchHits[j];
                Object value = this.getFieldValue(hit, (String)diversityField);
                if (value == this) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("diversityField {} does not exist. Reranking is skipped.", new Object[]{diversityField});
                    }
                    return searchHits;
                }
                for (Bucket bucket : bucketList) {
                    if (!bucket.contains(value)) continue;
                    bucket.add(hit, value);
                    insert = true;
                    break;
                }
                if (insert) continue;
                bucketList.add(this.bucketFactory.createBucket(hit, value, Float.valueOf(diversityThreshold)));
            }
            searchHits = this.createHits(length, bucketList);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("searchHits: {}", new Object[]{searchHits.length});
        }
        return searchHits;
    }

    private Object getFieldValue(InternalSearchHit hit, String fieldName) {
        SearchHitField field = (SearchHitField)hit.getFields().get(fieldName);
        if (field == null) {
            return this;
        }
        Object object = field.getValue();
        if (object instanceof BytesArray) {
            return ((BytesArray)object).toBytes();
        }
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Number) {
            return object;
        }
        return null;
    }

    private float[] parseFloats(String[] strings) {
        float[] values = new float[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            values[i] = Float.parseFloat(strings[i]);
        }
        return values;
    }

    protected InternalSearchHit[] createHits(int size, List<Bucket> bucketList) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} docs -> {} buckets", new Object[]{size, bucketList.size()});
            for (int i = 0; i < bucketList.size(); ++i) {
                Bucket bucket = bucketList.get(i);
                logger.debug(" bucket[{}] -> {} docs", new Object[]{i, bucket.size()});
            }
        }
        int pos = 0;
        InternalSearchHit[] newSearchHits = new InternalSearchHit[size];
        while (pos < size) {
            for (Bucket bucket : bucketList) {
                InternalSearchHit hit = bucket.get();
                if (hit == null) continue;
                newSearchHits[pos] = hit;
                ++pos;
                bucket.consume();
            }
        }
        return newSearchHits;
    }
}

