/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.filter;

import org.codelibs.elasticsearch.dynarank.ranker.DynamicRanker;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class SearchActionFilter
extends AbstractComponent
implements ActionFilter {
    private static final String SEARCH_REQUEST_INVOKED = "filter.codelibs.dynarank.Invoked";
    private int order;
    private DynamicRanker dynamicRanker;

    @Inject
    public SearchActionFilter(Settings settings) {
        super(settings);
        this.order = settings.getAsInt("indices.dynarank.filter.order", Integer.valueOf(10));
    }

    public int order() {
        return this.order;
    }

    public void apply(String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        if (!SearchAction.INSTANCE.name().equals(action)) {
            chain.proceed(action, request, (ActionListener)listener);
            return;
        }
        SearchRequest searchRequest = (SearchRequest)request;
        Boolean invoked = (Boolean)searchRequest.getHeader(SEARCH_REQUEST_INVOKED);
        if (invoked != null && invoked.booleanValue()) {
            ActionListener<SearchResponse> wrappedListener = this.dynamicRanker.wrapActionListener(action, searchRequest, listener);
            chain.proceed(action, request, wrappedListener == null ? listener : wrappedListener);
        } else {
            searchRequest.putHeader(SEARCH_REQUEST_INVOKED, (Object)Boolean.TRUE);
            chain.proceed(action, request, (ActionListener)listener);
        }
    }

    public void apply(String action, ActionResponse response, ActionListener listener, ActionFilterChain chain) {
        chain.proceed(action, response, listener);
    }

    public void setDynamicRanker(DynamicRanker dynamicRanker) {
        this.dynamicRanker = dynamicRanker;
    }
}

