/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.minhash;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.Version;
import org.codelibs.elasticsearch.dynarank.guava.common.hash.HashFunction;
import org.codelibs.elasticsearch.dynarank.guava.common.hash.Hashing;
import org.codelibs.elasticsearch.dynarank.guava.common.io.BaseEncoding;
import org.codelibs.elasticsearch.dynarank.minhash.analysis.MinHashTokenFilter;
import org.codelibs.elasticsearch.dynarank.minhash.util.FastBitSet;

public class MinHash {
    private MinHash() {
    }

    public static float compare(int numOfBits, String str1, String str2) {
        return MinHash.compare(numOfBits, BaseEncoding.base64().decode(str1), BaseEncoding.base64().decode(str2));
    }

    public static float compare(String str1, String str2) {
        return MinHash.compare(BaseEncoding.base64().decode(str1), BaseEncoding.base64().decode(str2));
    }

    public static float compare(byte[] data1, byte[] data2) {
        return MinHash.compare(data1.length * 8, data1, data2);
    }

    public static float compare(int numOfBits, byte[] data1, byte[] data2) {
        if (data1.length != data2.length) {
            return 0.0f;
        }
        int count = MinHash.countSameBits(data1, data2);
        return (float)count / (float)numOfBits;
    }

    protected static int countSameBits(byte[] data1, byte[] data2) {
        int count = 0;
        for (int i = 0; i < data1.length; ++i) {
            byte b1 = data1[i];
            byte b2 = data2[i];
            for (int j = 0; j < 8; ++j) {
                if ((b1 & 1) == (b2 & 1)) {
                    ++count;
                }
                b1 = (byte)(b1 >> 1);
                b2 = (byte)(b2 >> 1);
            }
        }
        return count;
    }

    public static HashFunction[] createHashFunctions(int seed, int num) {
        HashFunction[] hashFunctions = new HashFunction[num];
        for (int i = 0; i < num; ++i) {
            hashFunctions[i] = Hashing.murmur3_128(seed + i);
        }
        return hashFunctions;
    }

    public static byte[] calculate(Analyzer analyzer, String text) throws IOException {
        byte[] value = null;
        try (TokenStream stream = analyzer.tokenStream("minhash", text);){
            CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            stream.reset();
            if (stream.incrementToken()) {
                String minhashValue = termAtt.toString();
                value = BaseEncoding.base64().decode(minhashValue);
            }
            stream.end();
        }
        return value;
    }

    public static byte[] calculate(Data data) throws IOException {
        return MinHash.calculate(data.analyzer, data.text);
    }

    public static byte[] calculate(Data[] data) throws IOException {
        int bitSize = 0;
        for (Data target : data) {
            bitSize += target.numOfBits;
        }
        int pos = 0;
        FastBitSet bitSet = new FastBitSet(bitSize);
        for (Data target : data) {
            byte[] bytes;
            int count = 0;
            byte[] byArray = bytes = MinHash.calculate(target);
            int n = byArray.length;
            block2: for (int i = 0; i < n; ++i) {
                byte b;
                byte bits = b = byArray[i];
                for (int j = 0; j < 8; ++j) {
                    bitSet.set(pos, (bits & 1) == 1);
                    ++pos;
                    if (++count >= target.numOfBits) continue block2;
                    bits = (byte)(bits >> 1);
                }
            }
        }
        return bitSet.toByteArray();
    }

    public static String toBinaryString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(data.length * 8);
        byte[] byArray = data;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte element;
            byte bits = element = byArray[i];
            for (int j = 0; j < 8; ++j) {
                if ((bits & 0x80) == 128) {
                    buf.append('1');
                } else {
                    buf.append('0');
                }
                bits = (byte)(bits << 1);
            }
        }
        return buf.toString();
    }

    public static int bitCount(byte[] data) {
        int count = 0;
        byte[] byArray = data;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte element;
            byte bits = element = byArray[i];
            for (int j = 0; j < 8; ++j) {
                if ((bits & 1) == 1) {
                    ++count;
                }
                bits = (byte)(bits >> 1);
            }
        }
        return count;
    }

    public static Analyzer createAnalyzer(final Tokenizer tokenizer, final int hashBit, int seed, int num) {
        final HashFunction[] hashFunctions = MinHash.createHashFunctions(seed, num);
        Analyzer minhashAnalyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
                WhitespaceTokenizer baseTokenizer = tokenizer == null ? new WhitespaceTokenizer(Version.LUCENE_CURRENT, reader) : tokenizer;
                MinHashTokenFilter stream = new MinHashTokenFilter((TokenStream)baseTokenizer, hashFunctions, hashBit);
                return new Analyzer.TokenStreamComponents((Tokenizer)baseTokenizer, (TokenStream)stream);
            }
        };
        return minhashAnalyzer;
    }

    public static Data newData(Analyzer analyzer, String text, int numOfBits) {
        return new Data(analyzer, text, numOfBits);
    }

    public static class Data {
        final int numOfBits;
        final String text;
        final Analyzer analyzer;

        Data(Analyzer analyzer, String text, int numOfBits) {
            this.numOfBits = numOfBits;
            this.text = text;
            this.analyzer = analyzer;
        }
    }
}

