/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.minhash.util;

public class FastBitSet {
    final byte[] data;
    final int nbit;

    public FastBitSet(int nbit) {
        this.nbit = nbit;
        if (nbit == 0) {
            throw new IllegalArgumentException("nbit is above 0.");
        }
        this.data = new byte[(nbit - 1) / 8 + 1];
    }

    public void set(int bitIndex, boolean value) {
        int bytePos = bitIndex / 8;
        int bitPos = bitIndex % 8;
        if (bytePos >= this.data.length) {
            return;
        }
        switch (bitPos) {
            case 0: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xFE);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 1);
                break;
            }
            case 1: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xFD);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 2);
                break;
            }
            case 2: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xFB);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 4);
                break;
            }
            case 3: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xF7);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 8);
                break;
            }
            case 4: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xEF);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 0x10);
                break;
            }
            case 5: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xDF);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 0x20);
                break;
            }
            case 6: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0xBF);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 0x40);
                break;
            }
            case 7: {
                this.data[bytePos] = (byte)(this.data[bytePos] & 0x7F);
                if (!value) break;
                this.data[bytePos] = (byte)(this.data[bytePos] | 0x80);
                break;
            }
        }
    }

    public byte[] toByteArray() {
        return this.data;
    }
}

