/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.ranker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.codelibs.elasticsearch.dynarank.DynamicRankingException;
import org.codelibs.elasticsearch.dynarank.filter.SearchActionFilter;
import org.codelibs.elasticsearch.dynarank.guava.common.cache.Cache;
import org.codelibs.elasticsearch.dynarank.guava.common.cache.CacheBuilder;
import org.codelibs.elasticsearch.dynarank.ranker.RetrySearchException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.threadpool.ThreadPool;

public class DynamicRanker
extends AbstractLifecycleComponent<DynamicRanker> {
    public static final String DEFAULT_SCRIPT_TYPE = "inline";
    public static final String DEFAULT_SCRIPT_LANG = "groovy";
    public static final String INDEX_DYNARANK_SCRIPT = "index.dynarank.script_sort.script";
    public static final String INDEX_DYNARANK_SCRIPT_LANG = "index.dynarank.script_sort.lang";
    public static final String INDEX_DYNARANK_SCRIPT_TYPE = "index.dynarank.script_sort.type";
    public static final String INDEX_DYNARANK_SCRIPT_PARAMS = "index.dynarank.script_sort.params.";
    public static final String INDEX_DYNARANK_REORDER_SIZE = "index.dynarank.reorder_size";
    public static final String INDICES_DYNARANK_REORDER_SIZE = "indices.dynarank.reorder_size";
    public static final String INDICES_DYNARANK_CACHE_EXPIRE = "indices.dynarank.cache.expire";
    public static final String INDICES_DYNARANK_CACHE_CLEAN_INTERVAL = "indices.dynarank.cache.clean_interval";
    private static final String DYNARANK_RERANK_ENABLE = "_rerank";
    private ESLogger logger = ESLoggerFactory.getLogger((String)"script.dynarank.sort");
    private ClusterService clusterService;
    private Integer defaultReorderSize;
    private ScriptService scriptService;
    private Cache<String, ScriptInfo> scriptInfoCache;
    private ThreadPool threadPool;
    private TimeValue cleanInterval;
    private Reaper reaper;
    private Client client;

    @Inject
    public DynamicRanker(Settings settings, Client client, ClusterService clusterService, ScriptService scriptService, ThreadPool threadPool, ActionFilters filters) {
        super(settings);
        this.client = client;
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.threadPool = threadPool;
        this.logger.info("Initializing DynamicRanker", new Object[0]);
        this.defaultReorderSize = settings.getAsInt(INDICES_DYNARANK_REORDER_SIZE, Integer.valueOf(100));
        TimeValue expire = settings.getAsTime(INDICES_DYNARANK_CACHE_EXPIRE, null);
        this.cleanInterval = settings.getAsTime(INDICES_DYNARANK_CACHE_CLEAN_INTERVAL, TimeValue.timeValueSeconds((long)60L));
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder().concurrencyLevel(16);
        if (expire != null) {
            builder.expireAfterAccess(expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.scriptInfoCache = builder.build();
        for (ActionFilter filter : filters.filters()) {
            if (!(filter instanceof SearchActionFilter)) continue;
            ((SearchActionFilter)filter).setDynamicRanker(this);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Set DynamicRanker to " + filter, new Object[0]);
        }
    }

    protected void doStart() throws ElasticsearchException {
        this.reaper = new Reaper();
        this.threadPool.schedule(this.cleanInterval, "same", (Runnable)this.reaper);
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        this.reaper.close();
        this.scriptInfoCache.invalidateAll();
    }

    public ActionListener<SearchResponse> wrapActionListener(String action, final SearchRequest request, final ActionListener<SearchResponse> listener) {
        switch (request.searchType()) {
            case DFS_QUERY_AND_FETCH: 
            case QUERY_AND_FETCH: 
            case QUERY_THEN_FETCH: {
                break;
            }
            default: {
                return null;
            }
        }
        if (request.scroll() != null) {
            return null;
        }
        Object isRerank = request.getHeader(DYNARANK_RERANK_ENABLE);
        if (isRerank instanceof Boolean && !((Boolean)isRerank).booleanValue()) {
            return null;
        }
        BytesReference source = request.source();
        if (source == null) {
            return null;
        }
        String[] indices = request.indices();
        if (indices == null || indices.length != 1) {
            return null;
        }
        String index = indices[0];
        ScriptInfo scriptInfo = this.getScriptInfo(index);
        if (scriptInfo == null || scriptInfo.getScript() == null) {
            return null;
        }
        long startTime = System.nanoTime();
        try {
            final Map sourceAsMap = SourceLookup.sourceAsMap((BytesReference)source);
            final int size = this.getInt(sourceAsMap.get("size"), 10);
            final int from = this.getInt(sourceAsMap.get("from"), 0);
            if (size < 0 || from < 0) {
                return null;
            }
            if (from >= scriptInfo.getReorderSize()) {
                return null;
            }
            int maxSize = scriptInfo.getReorderSize();
            if (from + size > scriptInfo.getReorderSize()) {
                maxSize = from + size;
            }
            sourceAsMap.put("size", maxSize);
            sourceAsMap.put("from", 0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rewrite query: from:{}->{} size:{}->{}", new Object[]{from, 0, size, maxSize});
            }
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)Requests.CONTENT_TYPE);
            builder.map(sourceAsMap);
            request.source(builder.bytes(), true);
            final ActionListener<SearchResponse> searchResponseListener = this.createSearchResponseListener(listener, from, size, scriptInfo.getReorderSize(), startTime, scriptInfo);
            return new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    try {
                        searchResponseListener.onResponse((Object)response);
                    }
                    catch (RetrySearchException e) {
                        Map<String, Object> newSourceAsMap = e.rewrite(sourceAsMap);
                        if (newSourceAsMap == null) {
                            throw new DynamicRankingException("Failed to rewrite source: " + sourceAsMap);
                        }
                        newSourceAsMap.put("size", size);
                        newSourceAsMap.put("from", from);
                        if (DynamicRanker.this.logger.isDebugEnabled()) {
                            DynamicRanker.this.logger.debug("Original Query: \n{}\nNew Query: \n{}", new Object[]{sourceAsMap, newSourceAsMap});
                        }
                        try {
                            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)Requests.CONTENT_TYPE);
                            builder.map(newSourceAsMap);
                            request.source(builder.bytes(), true);
                            for (String name : request.getHeaders()) {
                                if (!name.startsWith("filter.codelibs.")) continue;
                                request.putHeader(name, (Object)Boolean.FALSE);
                            }
                            request.putHeader(DynamicRanker.DYNARANK_RERANK_ENABLE, (Object)Boolean.FALSE);
                            DynamicRanker.this.client.search(request, listener);
                        }
                        catch (IOException ioe) {
                            throw new DynamicRankingException("Failed to parse a new source.", ioe);
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    searchResponseListener.onFailure(t);
                }
            };
        }
        catch (IOException e) {
            throw new DynamicRankingException("Failed to parse a source.", e);
        }
    }

    public ScriptInfo getScriptInfo(final String index) {
        try {
            return this.scriptInfoCache.get(index, new Callable<ScriptInfo>(){

                @Override
                public ScriptInfo call() throws Exception {
                    MetaData metaData = DynamicRanker.this.clusterService.state().getMetaData();
                    String[] concreteIndices = metaData.concreteIndices(IndicesOptions.strictExpandOpenAndForbidClosed(), new String[]{index});
                    Settings indexSettings = null;
                    for (String concreteIndex : concreteIndices) {
                        Settings scriptSettings;
                        String script;
                        IndexMetaData indexMD = metaData.index(concreteIndex);
                        if (indexMD == null || (script = (scriptSettings = indexMD.settings()).get(DynamicRanker.INDEX_DYNARANK_SCRIPT)) == null || script.length() <= 0) continue;
                        indexSettings = scriptSettings;
                    }
                    if (indexSettings == null) {
                        return ScriptInfo.NO_SCRIPT_INFO;
                    }
                    return new ScriptInfo(indexSettings.get(DynamicRanker.INDEX_DYNARANK_SCRIPT), indexSettings.get(DynamicRanker.INDEX_DYNARANK_SCRIPT_LANG, DynamicRanker.DEFAULT_SCRIPT_LANG), indexSettings.get(DynamicRanker.INDEX_DYNARANK_SCRIPT_TYPE, DynamicRanker.DEFAULT_SCRIPT_TYPE), indexSettings.getByPrefix(DynamicRanker.INDEX_DYNARANK_SCRIPT_PARAMS), indexSettings.getAsInt(DynamicRanker.INDEX_DYNARANK_REORDER_SIZE, DynamicRanker.this.defaultReorderSize));
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("Failed to load ScriptInfo for {}.", (Throwable)e, new Object[]{index});
            return null;
        }
    }

    private ActionListener<SearchResponse> createSearchResponseListener(final ActionListener<SearchResponse> listener, final int from, final int size, final int reorderSize, final long startTime, final ScriptInfo scriptInfo) {
        return new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                if (response.getHits().getTotalHits() == 0L) {
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("No reranking results: {}", new Object[]{response});
                    }
                    listener.onResponse((Object)response);
                    return;
                }
                if (DynamicRanker.this.logger.isDebugEnabled()) {
                    DynamicRanker.this.logger.debug("Reranking results: {}", new Object[]{response});
                }
                try {
                    ShardSearchFailure[] shardFailures;
                    BytesStreamOutput out = new BytesStreamOutput();
                    response.writeTo((StreamOutput)out);
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Reading headers...", new Object[0]);
                    }
                    BytesStreamInput in = new BytesStreamInput(out.bytes());
                    Map headers = null;
                    if (in.readBoolean()) {
                        headers = in.readMap();
                    }
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Reading hits...", new Object[0]);
                    }
                    InternalSearchHits hits = InternalSearchHits.readSearchHits((StreamInput)in);
                    InternalSearchHits newHits = DynamicRanker.this.doReorder(hits, from, size, reorderSize, scriptInfo);
                    InternalFacets facets = null;
                    if (in.readBoolean()) {
                        facets = InternalFacets.readFacets((StreamInput)in);
                    }
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Reading aggregations...", new Object[0]);
                    }
                    InternalAggregations aggregations = null;
                    if (in.readBoolean()) {
                        aggregations = InternalAggregations.readAggregations((StreamInput)in);
                    }
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Reading suggest...", new Object[0]);
                    }
                    Suggest suggest = null;
                    if (in.readBoolean()) {
                        suggest = Suggest.readSuggest((XContentBuilderString)Suggest.Fields.SUGGEST, (StreamInput)in);
                    }
                    boolean timedOut = in.readBoolean();
                    Boolean terminatedEarly = null;
                    if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                        terminatedEarly = in.readOptionalBoolean();
                    }
                    InternalSearchResponse internalResponse = new InternalSearchResponse(newHits, facets, aggregations, suggest, timedOut, terminatedEarly);
                    int totalShards = in.readVInt();
                    int successfulShards = in.readVInt();
                    int size2 = in.readVInt();
                    if (size2 == 0) {
                        shardFailures = ShardSearchFailure.EMPTY_ARRAY;
                    } else {
                        shardFailures = new ShardSearchFailure[size2];
                        for (int i = 0; i < shardFailures.length; ++i) {
                            shardFailures[i] = ShardSearchFailure.readShardSearchFailure((StreamInput)in);
                        }
                    }
                    String scrollId = in.readOptionalString();
                    long tookInMillis = (System.nanoTime() - startTime) / 1000000L;
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Creating new SearchResponse...", new Object[0]);
                    }
                    SearchResponse newResponse = new SearchResponse(internalResponse, scrollId, totalShards, successfulShards, tookInMillis, shardFailures);
                    if (headers != null) {
                        for (Map.Entry entry : headers.entrySet()) {
                            newResponse.putHeader((String)entry.getKey(), entry.getValue());
                        }
                    }
                    listener.onResponse((Object)newResponse);
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Rewriting overhead time: {} - {} = {}ms", new Object[]{tookInMillis, response.getTookInMillis(), tookInMillis - response.getTookInMillis()});
                    }
                }
                catch (RetrySearchException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Failed to parse a search response.", (Throwable)e, new Object[0]);
                    }
                    throw new DynamicRankingException("Failed to parse a search response.", e);
                }
            }

            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        };
    }

    private InternalSearchHits doReorder(InternalSearchHits hits, int from, int size, int reorderSize, ScriptInfo scriptInfo) {
        InternalSearchHit[] newSearchHits;
        InternalSearchHit[] searchHits = hits.internalHits();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("searchHits.length <= reorderSize: {}", new Object[]{searchHits.length <= reorderSize});
        }
        if (searchHits.length <= reorderSize) {
            InternalSearchHit[] targets = this.onReorder(searchHits, scriptInfo);
            if (from >= targets.length) {
                newSearchHits = new InternalSearchHit[]{};
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Invalid argument: " + from + " >= " + targets.length, new Object[0]);
                }
            } else {
                int end = from + size;
                if (end > targets.length) {
                    end = targets.length;
                }
                newSearchHits = Arrays.copyOfRange(targets, from, end);
            }
        } else {
            int i;
            InternalSearchHit[] targets = Arrays.copyOfRange(searchHits, 0, reorderSize);
            targets = this.onReorder(targets, scriptInfo);
            ArrayList<InternalSearchHit> list = new ArrayList<InternalSearchHit>(size);
            for (i = from; i < targets.length; ++i) {
                list.add(targets[i]);
            }
            for (i = targets.length; i < searchHits.length; ++i) {
                list.add(searchHits[i]);
            }
            newSearchHits = list.toArray(new InternalSearchHit[list.size()]);
        }
        return new InternalSearchHits(newSearchHits, hits.totalHits(), hits.maxScore());
    }

    private InternalSearchHit[] onReorder(InternalSearchHit[] searchHits, ScriptInfo scriptInfo) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        InternalSearchHit[] hits = searchHits;
        vars.put("searchHits", hits);
        vars.putAll(scriptInfo.getSettings());
        CompiledScript compiledScript = this.scriptService.compile(scriptInfo.getLang(), scriptInfo.getScript(), scriptInfo.getScriptType());
        return (InternalSearchHit[])this.scriptService.executable(compiledScript, vars).run();
    }

    private int getInt(Object value, int defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        return defaultValue;
    }

    private class Reaper
    implements Runnable {
        private volatile boolean closed;

        private Reaper() {
        }

        void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.closed) {
                return;
            }
            try {
                for (Map.Entry entry : DynamicRanker.this.scriptInfoCache.asMap().entrySet()) {
                    String index = (String)entry.getKey();
                    IndexMetaData indexMD = DynamicRanker.this.clusterService.state().getMetaData().index(index);
                    if (indexMD == null) {
                        DynamicRanker.this.scriptInfoCache.invalidate(index);
                        if (!DynamicRanker.this.logger.isDebugEnabled()) continue;
                        DynamicRanker.this.logger.debug("Invalidate cache for " + index, new Object[0]);
                        continue;
                    }
                    Settings indexSettings = indexMD.settings();
                    String script = indexSettings.get(DynamicRanker.INDEX_DYNARANK_SCRIPT);
                    if (script == null || script.length() == 0) {
                        DynamicRanker.this.scriptInfoCache.invalidate(index);
                        if (!DynamicRanker.this.logger.isDebugEnabled()) continue;
                        DynamicRanker.this.logger.debug("Invalidate cache for " + index, new Object[0]);
                        continue;
                    }
                    ScriptInfo scriptInfo = new ScriptInfo(script, indexSettings.get(DynamicRanker.INDEX_DYNARANK_SCRIPT_LANG, DynamicRanker.DEFAULT_SCRIPT_LANG), indexSettings.get(DynamicRanker.INDEX_DYNARANK_SCRIPT_TYPE, DynamicRanker.DEFAULT_SCRIPT_TYPE), indexSettings.getByPrefix(DynamicRanker.INDEX_DYNARANK_SCRIPT_PARAMS), indexSettings.getAsInt(DynamicRanker.INDEX_DYNARANK_REORDER_SIZE, DynamicRanker.this.defaultReorderSize));
                    if (DynamicRanker.this.logger.isDebugEnabled()) {
                        DynamicRanker.this.logger.debug("Reload cache for " + index + " => " + scriptInfo, new Object[0]);
                    }
                    DynamicRanker.this.scriptInfoCache.put(index, scriptInfo);
                }
            }
            catch (Exception e) {
                DynamicRanker.this.logger.warn("Failed to update a cache for ScriptInfo.", (Throwable)e, new Object[0]);
            }
            finally {
                DynamicRanker.this.threadPool.schedule(DynamicRanker.this.cleanInterval, "generic", (Runnable)DynamicRanker.this.reaper);
            }
        }
    }

    public static class ScriptInfo {
        protected static final ScriptInfo NO_SCRIPT_INFO = new ScriptInfo();
        private String script;
        private String lang;
        private ScriptService.ScriptType scriptType;
        private Map<String, Object> settings;
        private int reorderSize;

        ScriptInfo() {
        }

        ScriptInfo(String script, String lang, String scriptType, Settings settings, int reorderSize) {
            this.script = script;
            this.lang = lang;
            this.reorderSize = reorderSize;
            this.settings = new HashMap<String, Object>();
            for (String name : settings.names()) {
                String value = settings.get(name);
                if (value != null) {
                    this.settings.put(name, value);
                    continue;
                }
                this.settings.put(name, settings.getAsArray(name));
            }
            this.scriptType = "INDEXED".equalsIgnoreCase(scriptType) ? ScriptService.ScriptType.INDEXED : ("FILE".equalsIgnoreCase(scriptType) ? ScriptService.ScriptType.FILE : ScriptService.ScriptType.INLINE);
        }

        public String getScript() {
            return this.script;
        }

        public String getLang() {
            return this.lang;
        }

        public ScriptService.ScriptType getScriptType() {
            return this.scriptType;
        }

        public Map<String, Object> getSettings() {
            return this.settings;
        }

        public int getReorderSize() {
            return this.reorderSize;
        }

        public String toString() {
            return "ScriptInfo [script=" + this.script + ", lang=" + this.lang + ", scriptType=" + this.scriptType + ", settings=" + this.settings + ", reorderSize=" + this.reorderSize + "]";
        }
    }
}

