/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.dynarank.script.bucket.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.dynarank.DynamicRankingException;
import org.codelibs.elasticsearch.dynarank.ranker.RetrySearchException;
import org.codelibs.elasticsearch.dynarank.script.bucket.Bucket;
import org.codelibs.elasticsearch.dynarank.script.bucket.BucketFactory;
import org.codelibs.elasticsearch.dynarank.script.bucket.Buckets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.internal.InternalSearchHit;

public class StandardBuckets
implements Buckets {
    private static ESLogger logger = ESLoggerFactory.getLogger((String)"script.dynarank.sort.bucket.standard");
    protected BucketFactory bucketFactory;
    protected Map<String, Object> params;

    public StandardBuckets(BucketFactory bucketFactory, Map<String, Object> params) {
        this.bucketFactory = bucketFactory;
        this.params = params;
    }

    @Override
    public InternalSearchHit[] getHits() {
        Object shuffleSeed;
        InternalSearchHit[] searchHits = (InternalSearchHit[])this.params.get("searchHits");
        int length = searchHits.length;
        Object[] diversityFields = (String[])this.params.get("diversity_fields");
        if (diversityFields == null) {
            throw new DynamicRankingException("diversity_fields is null.");
        }
        Object[] thresholds = (String[])this.params.get("diversity_thresholds");
        if (thresholds == null) {
            throw new DynamicRankingException("diversity_thresholds is null.");
        }
        float[] diversityThresholds = this.parseFloats((String[])thresholds);
        if (logger.isDebugEnabled()) {
            logger.debug("diversity_fields: {}, : diversity_thresholds{}", new Object[]{Arrays.toString(diversityFields), Arrays.toString(thresholds)});
        }
        int maxNumOfBuckets = 0;
        int minNumOfBuckets = Integer.MAX_VALUE;
        for (int i = diversityFields.length - 1; i >= 0; --i) {
            Object diversityField = diversityFields[i];
            float diversityThreshold = diversityThresholds[i];
            ArrayList<Bucket> bucketList = new ArrayList<Bucket>();
            for (int j = 0; j < length; ++j) {
                boolean insert = false;
                InternalSearchHit hit = searchHits[j];
                Object value = this.getFieldValue(hit, (String)diversityField);
                if (value == this) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("diversityField {} does not exist. Reranking is skipped.", new Object[]{diversityField});
                    }
                    return searchHits;
                }
                for (Bucket bucket : bucketList) {
                    if (!bucket.contains(value)) continue;
                    bucket.add(hit, value);
                    insert = true;
                    break;
                }
                if (insert) continue;
                bucketList.add(this.bucketFactory.createBucket(hit, value, Float.valueOf(diversityThreshold)));
            }
            if (bucketList.size() > maxNumOfBuckets) {
                maxNumOfBuckets = bucketList.size();
            }
            if (bucketList.size() < minNumOfBuckets) {
                minNumOfBuckets = bucketList.size();
            }
            searchHits = this.createHits(length, bucketList);
        }
        int minBucketThreshold = 0;
        int maxBucketThreshold = 0;
        Object minBucketThresholdStr = this.params.get("min_bucket_threshold");
        if (minBucketThresholdStr instanceof String) {
            try {
                minBucketThreshold = Integer.parseInt(minBucketThresholdStr.toString());
            }
            catch (NumberFormatException e) {
                throw new DynamicRankingException("Invalid value of min_bucket_threshold: " + minBucketThresholdStr.toString(), e);
            }
        } else if (minBucketThresholdStr instanceof Number) {
            minBucketThreshold = ((Number)minBucketThresholdStr).intValue();
        }
        Object maxBucketThresholdStr = this.params.get("max_bucket_threshold");
        if (maxBucketThresholdStr instanceof String) {
            try {
                maxBucketThreshold = Integer.parseInt(maxBucketThresholdStr.toString());
            }
            catch (NumberFormatException e) {
                throw new DynamicRankingException("Invalid value of max_bucket_threshold: " + maxBucketThresholdStr.toString(), e);
            }
        } else if (maxBucketThresholdStr instanceof Number) {
            maxBucketThreshold = ((Number)maxBucketThresholdStr).intValue();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("searchHits: {}, minNumOfBuckets: {}, maxNumOfBuckets: {}, minBucketSize: {}, maxBucketThreshold: {}", new Object[]{searchHits.length, minNumOfBuckets, maxNumOfBuckets, minBucketThreshold, maxBucketThreshold});
        }
        if ((minBucketThreshold > 0 && minBucketThreshold >= minNumOfBuckets || maxBucketThreshold > 0 && maxBucketThreshold >= maxNumOfBuckets) && (shuffleSeed = this.params.get("shuffle_seed")) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("minBucketSize: {}", new Object[]{shuffleSeed});
            }
            throw new RetrySearchException(new RetrySearchException.QueryRewriter(){

                @Override
                public Map<String, Object> rewrite(Map<String, Object> source) {
                    Object queryObj = source.remove("query");
                    if (queryObj == null) {
                        return null;
                    }
                    Object shuffleWeight = StandardBuckets.this.params.get("shuffle_weight");
                    if (shuffleWeight == null) {
                        shuffleWeight = 1;
                    }
                    Object shuffleBoostMode = StandardBuckets.this.params.get("shuffle_boost_mode");
                    HashMap<String, Object> randomScoreMap = new HashMap<String, Object>(1, 1.0f);
                    randomScoreMap.put("seed", shuffleSeed);
                    HashMap<String, Object> funcMap = new HashMap<String, Object>(2, 1.0f);
                    funcMap.put("random_score", randomScoreMap);
                    funcMap.put("weight", shuffleWeight);
                    ArrayList<HashMap<String, Object>> funcList = new ArrayList<HashMap<String, Object>>(1);
                    funcList.add(funcMap);
                    HashMap<String, Object> funcScoreMap = new HashMap<String, Object>(3, 1.0f);
                    funcScoreMap.put("query", queryObj);
                    funcScoreMap.put("functions", funcList);
                    if (shuffleBoostMode != null) {
                        funcScoreMap.put("boost_mode", shuffleBoostMode.toString());
                    }
                    HashMap<String, HashMap<String, Object>> queryMap = new HashMap<String, HashMap<String, Object>>(1, 1.0f);
                    queryMap.put("function_score", funcScoreMap);
                    source.put("query", queryMap);
                    return source;
                }
            });
        }
        return searchHits;
    }

    private Object getFieldValue(InternalSearchHit hit, String fieldName) {
        SearchHitField field = (SearchHitField)hit.getFields().get(fieldName);
        if (field == null) {
            return this;
        }
        Object object = field.getValue();
        if (object instanceof BytesArray) {
            return ((BytesArray)object).toBytes();
        }
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Number) {
            return object;
        }
        return null;
    }

    private float[] parseFloats(String[] strings) {
        float[] values = new float[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            values[i] = Float.parseFloat(strings[i]);
        }
        return values;
    }

    protected InternalSearchHit[] createHits(int size, List<Bucket> bucketList) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} docs -> {} buckets", new Object[]{size, bucketList.size()});
            for (int i = 0; i < bucketList.size(); ++i) {
                Bucket bucket = bucketList.get(i);
                logger.debug(" bucket[{}] -> {} docs", new Object[]{i, bucket.size()});
            }
        }
        int pos = 0;
        InternalSearchHit[] newSearchHits = new InternalSearchHit[size];
        while (pos < size) {
            for (Bucket bucket : bucketList) {
                InternalSearchHit hit = bucket.get();
                if (hit == null) continue;
                newSearchHits[pos] = hit;
                ++pos;
                bucket.consume();
            }
        }
        return newSearchHits;
    }
}

