/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.langfield.detect;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.elasticsearch.langfield.detect.LangDetector;
import org.codelibs.elasticsearch.langfield.detect.util.LangProfile;
import org.elasticsearch.ElasticsearchException;

public class LangDetectorFactory {
    public Map<String, double[]> wordLangProbMap = new HashMap<String, double[]>();
    public List<String> langlist = new ArrayList<String>();
    public Long seed = null;

    LangDetectorFactory() {
    }

    public static LangDetectorFactory create(File profileDirectory) {
        LangDetectorFactory factory = new LangDetectorFactory();
        File[] listFiles = profileDirectory.listFiles();
        if (listFiles == null) {
            throw new ElasticsearchException("Not found profile: " + profileDirectory, new Object[0]);
        }
        ObjectMapper mapper = new ObjectMapper();
        int langsize = listFiles.length;
        int index = 0;
        for (File file : listFiles) {
            if (file.getName().startsWith(".") || !file.isFile()) continue;
            LangProfile profile = AccessController.doPrivileged(() -> {
                try (FileInputStream is = new FileInputStream(file);){
                    LangProfile langProfile = (LangProfile)mapper.readValue((InputStream)is, LangProfile.class);
                    return langProfile;
                }
                catch (IOException e1) {
                    throw new ElasticsearchException("can't open '" + file.getName() + "'", (Throwable)e1, new Object[0]);
                }
                catch (Exception e2) {
                    throw new ElasticsearchException("profile format error in '" + file.getName() + "'", (Throwable)e2, new Object[0]);
                }
            });
            factory.addProfile(profile, index, langsize);
            ++index;
        }
        return factory;
    }

    public static LangDetectorFactory create(String ... langs) {
        LangDetectorFactory factory = new LangDetectorFactory();
        ObjectMapper mapper = new ObjectMapper();
        int langsize = langs.length;
        int index = 0;
        for (String lang : langs) {
            LangProfile profile = AccessController.doPrivileged(() -> {
                try (InputStream is = LangDetectorFactory.class.getResourceAsStream("/profiles/" + lang);){
                    if (is == null) {
                        throw new IOException("'/profiles/" + lang + "' does not exist.");
                    }
                    LangProfile langProfile = (LangProfile)mapper.readValue(is, LangProfile.class);
                    return langProfile;
                }
                catch (IOException e1) {
                    throw new ElasticsearchException("can't open 'profiles/" + lang + "'", (Throwable)e1, new Object[0]);
                }
                catch (Exception e2) {
                    throw new ElasticsearchException("profile format error in 'profiles/" + lang + "'", (Throwable)e2, new Object[0]);
                }
            });
            factory.addProfile(profile, index, langsize);
            ++index;
        }
        return factory;
    }

    void addProfile(LangProfile profile, int index, int langsize) {
        String lang = profile.name;
        if (this.langlist.contains(lang)) {
            throw new ElasticsearchException("duplicate the same language profile", new Object[0]);
        }
        this.langlist.add(lang);
        for (String word : profile.freq.keySet()) {
            double prob;
            int length;
            if (!this.wordLangProbMap.containsKey(word)) {
                this.wordLangProbMap.put(word, new double[langsize]);
            }
            if ((length = word.length()) < 1 || length > 3) continue;
            this.wordLangProbMap.get((Object)word)[index] = prob = profile.freq.get(word).doubleValue() / (double)profile.nWords[length - 1];
        }
    }

    public LangDetector getLangDetector() {
        if (this.langlist.size() == 0) {
            throw new ElasticsearchException("need to load profiles", new Object[0]);
        }
        LangDetector langDetector = new LangDetector(this);
        return langDetector;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public final List<String> getLangList() {
        return Collections.unmodifiableList(this.langlist);
    }
}

