/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.elasticsearch.langfield.detect.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codelibs.elasticsearch.langfield.detect.util.NGram;

public class LangProfile {
    private static final int MINIMUM_FREQ = 2;
    private static final int LESS_FREQ_RATIO = 100000;
    @JsonProperty(value="name")
    public String name = null;
    @JsonProperty(value="freq")
    public Map<String, Integer> freq = new HashMap<String, Integer>();
    @JsonProperty(value="n_words")
    public int[] nWords = new int[3];

    public LangProfile() {
    }

    public LangProfile(String name) {
        this.name = name;
    }

    public void add(String gram) {
        if (this.name == null || gram == null) {
            return;
        }
        int len = gram.length();
        if (len < 1 || len > 3) {
            return;
        }
        int n = len - 1;
        this.nWords[n] = this.nWords[n] + 1;
        if (this.freq.containsKey(gram)) {
            this.freq.put(gram, this.freq.get(gram) + 1);
        } else {
            this.freq.put(gram, 1);
        }
    }

    public void omitLessFreq() {
        if (this.name == null) {
            return;
        }
        int threshold = this.nWords[0] / 100000;
        if (threshold < 2) {
            threshold = 2;
        }
        Set<String> keys = this.freq.keySet();
        int roman = 0;
        Iterator<String> i = keys.iterator();
        while (i.hasNext()) {
            String key = i.next();
            int count = this.freq.get(key);
            if (count <= threshold) {
                int n = key.length() - 1;
                this.nWords[n] = this.nWords[n] - count;
                i.remove();
                continue;
            }
            if (!key.matches("^[A-Za-z]$")) continue;
            roman += count;
        }
        if (roman < this.nWords[0] / 3) {
            Set<String> keys2 = this.freq.keySet();
            Iterator<String> i2 = keys2.iterator();
            while (i2.hasNext()) {
                String key = i2.next();
                if (!key.matches(".*[A-Za-z].*")) continue;
                int n = key.length() - 1;
                this.nWords[n] = this.nWords[n] - this.freq.get(key);
                i2.remove();
            }
        }
    }

    public void update(String text) {
        if (text == null) {
            return;
        }
        text = NGram.normalize_vi(text);
        NGram gram = new NGram();
        for (int i = 0; i < text.length(); ++i) {
            gram.addChar(text.charAt(i));
            for (int n = 1; n <= 3; ++n) {
                this.add(gram.get(n));
            }
        }
    }
}

